/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.AbstractSvmModel;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.LibSvmUtils;
import com.facebook.presto.ml.Regressor;
import com.facebook.presto.ml.type.ModelType;
import com.facebook.presto.ml.type.RegressorType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;

public class SvmRegressor
extends AbstractSvmModel
implements Regressor {
    public SvmRegressor() {
        this(LibSvmUtils.parseParameters(""));
    }

    public SvmRegressor(svm_parameter params) {
        super(params);
    }

    private SvmRegressor(svm_model model) {
        super(model);
    }

    public static SvmRegressor deserialize(byte[] modelData) {
        try {
            svm_model model = svm.svm_load_model((BufferedReader)new BufferedReader(new InputStreamReader(new ByteArrayInputStream(modelData))));
            return new SvmRegressor(model);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public double regress(FeatureVector features) {
        Preconditions.checkNotNull((Object)this.model, (Object)"model is null");
        return svm.svm_predict((svm_model)this.model, (svm_node[])SvmRegressor.toSvmNodes(features));
    }

    @Override
    public ModelType getType() {
        return RegressorType.REGRESSOR;
    }

    @Override
    protected int getLibsvmType() {
        return 4;
    }
}

