/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.block.VariableWidthBlockEncoding;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VariableWidthType;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public class ModelType
implements VariableWidthType {
    public static final ModelType MODEL = new ModelType();
    public static final BlockEncodingFactory<?> BLOCK_ENCODING_FACTORY = new VariableWidthBlockEncoding.VariableWidthBlockEncodingFactory((Type)MODEL);

    @JsonCreator
    public ModelType() {
    }

    public static ModelType getInstance() {
        return MODEL;
    }

    public String getName() {
        return "Model";
    }

    public Class<?> getJavaType() {
        return Slice.class;
    }

    public int getLength(Slice slice, int offset) {
        return ModelType.getValueSize(slice, offset) + 4;
    }

    public Slice getSlice(Slice slice, int offset) {
        return slice.slice(offset + 4, ModelType.getValueSize(slice, offset));
    }

    public int writeSlice(SliceOutput sliceOutput, Slice value, int offset, int length) {
        sliceOutput.writeInt(length);
        sliceOutput.writeBytes(value, offset, length);
        return length + 4;
    }

    public boolean equalTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        throw new UnsupportedOperationException(String.format("%s type is not comparable", this.getName()));
    }

    public boolean equalTo(Slice leftSlice, int leftOffset, BlockCursor rightCursor) {
        throw new UnsupportedOperationException(String.format("%s type is not comparable", this.getName()));
    }

    public int hash(Slice slice, int offset) {
        throw new UnsupportedOperationException(String.format("%s type is not comparable", this.getName()));
    }

    public int compareTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        throw new UnsupportedOperationException(String.format("%s type is not ordered", this.getName()));
    }

    public void appendTo(Slice slice, int offset, BlockBuilder blockBuilder) {
        int length = ModelType.getValueSize(slice, offset);
        blockBuilder.appendSlice(slice, offset + 4, length);
    }

    public void appendTo(Slice slice, int offset, SliceOutput sliceOutput) {
        int length = this.getLength(slice, offset);
        sliceOutput.writeBytes(slice, offset, length);
    }

    public Object getObjectValue(ConnectorSession session, Slice slice, int offset) {
        return String.format("<%s>", this.getName());
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return new VariableWidthBlockBuilder((VariableWidthType)this, blockBuilderStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static int getValueSize(Slice slice, int offset) {
        return slice.getInt(offset);
    }

    public String toString() {
        return this.getName();
    }
}

