/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.metadata.FunctionFactory;
import com.facebook.presto.ml.MLFunctionFactory;
import com.facebook.presto.ml.type.ClassifierType;
import com.facebook.presto.ml.type.ModelType;
import com.facebook.presto.ml.type.RegressorType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class MLPlugin
implements Plugin {
    private Map<String, String> optionalConfig = ImmutableMap.of();

    public synchronized void setOptionalConfig(Map<String, String> optionalConfig) {
        this.optionalConfig = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(optionalConfig, (Object)"optionalConfig is null")));
    }

    public synchronized Map<String, String> getOptionalConfig() {
        return this.optionalConfig;
    }

    @Inject
    public void setBlockEncodingManager(BlockEncodingManager blockEncodingManager) {
        Preconditions.checkNotNull((Object)blockEncodingManager, (Object)"blockEncodingManager is null");
        blockEncodingManager.addBlockEncodingFactory(ModelType.BLOCK_ENCODING_FACTORY);
        blockEncodingManager.addBlockEncodingFactory(ClassifierType.BLOCK_ENCODING_FACTORY);
        blockEncodingManager.addBlockEncodingFactory(RegressorType.BLOCK_ENCODING_FACTORY);
    }

    public synchronized <T> List<T> getServices(Class<T> type) {
        if (type == FunctionFactory.class) {
            return ImmutableList.of(type.cast(new MLFunctionFactory()));
        }
        if (type == Type.class) {
            return ImmutableList.of(type.cast(ModelType.MODEL), type.cast(ClassifierType.CLASSIFIER), type.cast(RegressorType.REGRESSOR));
        }
        return ImmutableList.of();
    }
}

