/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.Classifier;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.Model;
import com.facebook.presto.ml.ModelUtils;
import com.facebook.presto.ml.Regressor;
import com.facebook.presto.ml.type.ClassifierType;
import com.facebook.presto.ml.type.RegressorType;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.HashCode;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.HashMap;

public final class MLFunctions {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Cache<HashCode, Model> MODEL_CACHE = CacheBuilder.newBuilder().maximumSize(5L).build();

    private MLFunctions() {
    }

    @ScalarFunction
    @SqlType(value=BigintType.class)
    public static long classify(@SqlType(value=VarcharType.class) Slice featuresMap, @SqlType(value=ClassifierType.class) Slice modelSlice) {
        FeatureVector features = ModelUtils.jsonToFeatures(featuresMap);
        Model model = MLFunctions.getOrLoadModel(modelSlice);
        Preconditions.checkArgument((model instanceof Classifier && model.getType().equals(ClassifierType.CLASSIFIER) ? 1 : 0) != 0, (Object)"model is not a classifier");
        return ((Classifier)model).classify(features);
    }

    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double regress(@SqlType(value=VarcharType.class) Slice featuresMap, @SqlType(value=RegressorType.class) Slice modelSlice) {
        FeatureVector features = ModelUtils.jsonToFeatures(featuresMap);
        Model model = MLFunctions.getOrLoadModel(modelSlice);
        Preconditions.checkArgument((model instanceof Regressor && model.getType().equals(RegressorType.REGRESSOR) ? 1 : 0) != 0, (Object)"model is not a regressor");
        return ((Regressor)model).regress(features);
    }

    private static Model getOrLoadModel(Slice slice) {
        HashCode modelHash = ModelUtils.modelHash(slice);
        Model model = (Model)MODEL_CACHE.getIfPresent((Object)modelHash);
        if (model == null) {
            model = ModelUtils.deserialize(slice);
            MODEL_CACHE.put((Object)modelHash, (Object)model);
        }
        return model;
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice features(@SqlType(value=DoubleType.class) double f1) {
        return MLFunctions.featuresHelper(f1);
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice features(@SqlType(value=DoubleType.class) double f1, @SqlType(value=DoubleType.class) double f2) {
        return MLFunctions.featuresHelper(f1, f2);
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice features(@SqlType(value=DoubleType.class) double f1, @SqlType(value=DoubleType.class) double f2, @SqlType(value=DoubleType.class) double f3) {
        return MLFunctions.featuresHelper(f1, f2, f3);
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice features(@SqlType(value=DoubleType.class) double f1, @SqlType(value=DoubleType.class) double f2, @SqlType(value=DoubleType.class) double f3, @SqlType(value=DoubleType.class) double f4) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4);
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice features(@SqlType(value=DoubleType.class) double f1, @SqlType(value=DoubleType.class) double f2, @SqlType(value=DoubleType.class) double f3, @SqlType(value=DoubleType.class) double f4, @SqlType(value=DoubleType.class) double f5) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5);
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice features(@SqlType(value=DoubleType.class) double f1, @SqlType(value=DoubleType.class) double f2, @SqlType(value=DoubleType.class) double f3, @SqlType(value=DoubleType.class) double f4, @SqlType(value=DoubleType.class) double f5, @SqlType(value=DoubleType.class) double f6) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5, f6);
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice features(@SqlType(value=DoubleType.class) double f1, @SqlType(value=DoubleType.class) double f2, @SqlType(value=DoubleType.class) double f3, @SqlType(value=DoubleType.class) double f4, @SqlType(value=DoubleType.class) double f5, @SqlType(value=DoubleType.class) double f6, @SqlType(value=DoubleType.class) double f7) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5, f6, f7);
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice features(@SqlType(value=DoubleType.class) double f1, @SqlType(value=DoubleType.class) double f2, @SqlType(value=DoubleType.class) double f3, @SqlType(value=DoubleType.class) double f4, @SqlType(value=DoubleType.class) double f5, @SqlType(value=DoubleType.class) double f6, @SqlType(value=DoubleType.class) double f7, @SqlType(value=DoubleType.class) double f8) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5, f6, f7, f8);
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice features(@SqlType(value=DoubleType.class) double f1, @SqlType(value=DoubleType.class) double f2, @SqlType(value=DoubleType.class) double f3, @SqlType(value=DoubleType.class) double f4, @SqlType(value=DoubleType.class) double f5, @SqlType(value=DoubleType.class) double f6, @SqlType(value=DoubleType.class) double f7, @SqlType(value=DoubleType.class) double f8, @SqlType(value=DoubleType.class) double f9) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice features(@SqlType(value=DoubleType.class) double f1, @SqlType(value=DoubleType.class) double f2, @SqlType(value=DoubleType.class) double f3, @SqlType(value=DoubleType.class) double f4, @SqlType(value=DoubleType.class) double f5, @SqlType(value=DoubleType.class) double f6, @SqlType(value=DoubleType.class) double f7, @SqlType(value=DoubleType.class) double f8, @SqlType(value=DoubleType.class) double f9, @SqlType(value=DoubleType.class) double f10) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10);
    }

    private static Slice featuresHelper(double ... features) {
        HashMap<Integer, Double> featureMap = new HashMap<Integer, Double>();
        for (int i = 0; i < features.length; ++i) {
            featureMap.put(i, features[i]);
        }
        try {
            return Slices.utf8Slice((String)OBJECT_MAPPER.writeValueAsString(featureMap));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

