/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.FeatureVector;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class Dataset {
    private final List<FeatureVector> datapoints;
    private final List<Double> labels;

    public Dataset(List<Double> labels, List<FeatureVector> datapoints) {
        Preconditions.checkNotNull(datapoints, (Object)"datapoints is null");
        Preconditions.checkNotNull(labels, (Object)"labels is null");
        Preconditions.checkArgument((datapoints.size() == labels.size() ? 1 : 0) != 0, (Object)"datapoints and labels have different sizes");
        this.labels = ImmutableList.copyOf(labels);
        this.datapoints = ImmutableList.copyOf(datapoints);
    }

    public List<FeatureVector> getDatapoints() {
        return this.datapoints;
    }

    public List<Double> getLabels() {
        return this.labels;
    }
}

