/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.ml.ClassifierFeatureTransformer;
import com.facebook.presto.ml.Dataset;
import com.facebook.presto.ml.FeatureUnitNormalizer;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.LearnState;
import com.facebook.presto.ml.LibSvmUtils;
import com.facebook.presto.ml.ModelUtils;
import com.facebook.presto.ml.StringClassifierAdapter;
import com.facebook.presto.ml.SvmClassifier;
import com.facebook.presto.ml.type.ClassifierType;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;
import java.util.Map;

@AggregationFunction(value="learn_libsvm_classifier", decomposable=false)
public final class LearnLibSvmVarcharClassifierAggregation {
    private LearnLibSvmVarcharClassifierAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LearnState state, @SqlType(value="varchar") Slice label, @SqlType(value="map(bigint,double)") Block features, @SqlType(value="varchar") Slice parameters) {
        state.getLabels().add(Double.valueOf(state.enumerateLabel(label.toStringUtf8())));
        FeatureVector featureVector = ModelUtils.toFeatures(features);
        state.addMemoryUsage(featureVector.getEstimatedSize());
        state.getFeatureVectors().add(featureVector);
        state.setParameters(parameters);
    }

    @CombineFunction
    public static void combine(@AggregationState LearnState state, @AggregationState LearnState otherState) {
        throw new UnsupportedOperationException("LEARN must run on a single machine");
    }

    @OutputFunction(value="Classifier<varchar>")
    public static void output(@AggregationState LearnState state, BlockBuilder out) {
        Dataset dataset = new Dataset(state.getLabels(), state.getFeatureVectors(), (Map<Integer, String>)state.getLabelEnumeration().inverse());
        StringClassifierAdapter model = new StringClassifierAdapter(new ClassifierFeatureTransformer(new SvmClassifier(LibSvmUtils.parseParameters(state.getParameters().toStringUtf8())), new FeatureUnitNormalizer()));
        model.train(dataset);
        ClassifierType.VARCHAR_CLASSIFIER.writeSlice(out, ModelUtils.serialize(model));
    }
}

