/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.AbstractFeatureTransformation;
import com.facebook.presto.ml.Dataset;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.type.ModelType;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class FeatureVectorUnitNormalizer
extends AbstractFeatureTransformation {
    @Override
    public ModelType getType() {
        return ModelType.MODEL;
    }

    @Override
    public byte[] getSerializedData() {
        return new byte[0];
    }

    public static FeatureVectorUnitNormalizer deserialize(byte[] modelData) {
        Preconditions.checkArgument((modelData.length == 0 ? 1 : 0) != 0, (Object)"modelData should be empty");
        return new FeatureVectorUnitNormalizer();
    }

    @Override
    public void train(Dataset dataset) {
    }

    @Override
    public FeatureVector transform(FeatureVector features) {
        double sumSquares = 0.0;
        for (Double value : features.getFeatures().values()) {
            sumSquares += value * value;
        }
        double magnitude = Math.sqrt(sumSquares);
        HashMap<Integer, Double> transformed = new HashMap<Integer, Double>();
        for (Map.Entry<Integer, Double> entry : features.getFeatures().entrySet()) {
            transformed.put(entry.getKey(), entry.getValue() / magnitude);
        }
        return new FeatureVector(transformed);
    }
}

