/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.Model;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import java.util.List;

public final class MLFeaturesFunctions {
    private static final Cache<HashCode, Model> MODEL_CACHE = CacheBuilder.newBuilder().maximumSize(5L).build();
    private static final String MAP_BIGINT_DOUBLE = "map(bigint,double)";
    private final PageBuilder pageBuilder;

    public MLFeaturesFunctions(@TypeParameter(value="map(bigint,double)") Type mapType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public Block features(@SqlType(value="double") double f1) {
        return this.featuresHelper(f1);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2) {
        return this.featuresHelper(f1, f2);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3) {
        return this.featuresHelper(f1, f2, f3);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4) {
        return this.featuresHelper(f1, f2, f3, f4);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5) {
        return this.featuresHelper(f1, f2, f3, f4, f5);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6) {
        return this.featuresHelper(f1, f2, f3, f4, f5, f6);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7) {
        return this.featuresHelper(f1, f2, f3, f4, f5, f6, f7);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8) {
        return this.featuresHelper(f1, f2, f3, f4, f5, f6, f7, f8);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8, @SqlType(value="double") double f9) {
        return this.featuresHelper(f1, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8, @SqlType(value="double") double f9, @SqlType(value="double") double f10) {
        return this.featuresHelper(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10);
    }

    private Block featuresHelper(double ... features) {
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder mapBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < features.length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
            DoubleType.DOUBLE.writeDouble(blockBuilder, features[i]);
        }
        mapBlockBuilder.closeEntry();
        this.pageBuilder.declarePosition();
        return (Block)mapBlockBuilder.getObject(mapBlockBuilder.getPositionCount() - 1, Block.class);
    }
}

