/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.EvaluateClassifierPredictionsState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;

public class EvaluateClassifierPredictionsStateSerializer
implements AccumulatorStateSerializer<EvaluateClassifierPredictionsState> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private static final String TRUE_POSITIVES = "truePositives";
    private static final String FALSE_POSITIVES = "falsePositives";
    private static final String FALSE_NEGATIVES = "falseNegatives";

    public Type getSerializedType() {
        return VarcharType.VARCHAR;
    }

    public void serialize(EvaluateClassifierPredictionsState state, BlockBuilder out) {
        HashMap<String, Map<String, Integer>> jsonState = new HashMap<String, Map<String, Integer>>();
        jsonState.put(TRUE_POSITIVES, state.getTruePositives());
        jsonState.put(FALSE_POSITIVES, state.getFalsePositives());
        jsonState.put(FALSE_NEGATIVES, state.getFalseNegatives());
        try {
            VarcharType.VARCHAR.writeSlice(out, Slices.utf8Slice((String)OBJECT_MAPPER.writeValueAsString(jsonState)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void deserialize(Block block, int index, EvaluateClassifierPredictionsState state) {
        Map jsonState;
        Slice slice = VarcharType.VARCHAR.getSlice(block, index);
        try {
            jsonState = (Map)OBJECT_MAPPER.readValue(slice.getBytes(), (TypeReference)new TypeReference<Map<String, Map<String, Integer>>>(){});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        state.addMemoryUsage(slice.length());
        state.getTruePositives().putAll((Map)jsonState.getOrDefault(TRUE_POSITIVES, ImmutableMap.of()));
        state.getFalsePositives().putAll((Map)jsonState.getOrDefault(FALSE_POSITIVES, ImmutableMap.of()));
        state.getFalseNegatives().putAll((Map)jsonState.getOrDefault(FALSE_NEGATIVES, ImmutableMap.of()));
    }
}

