/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.EvaluateClassifierPredictionsState;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.util.array.ObjectBigArray;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jol.info.ClassLayout;

public class EvaluateClassifierPredictionsStateFactory
implements AccumulatorStateFactory<EvaluateClassifierPredictionsState> {
    private static final long HASH_MAP_SIZE = ClassLayout.parseClass(HashMap.class).instanceSize();

    public EvaluateClassifierPredictionsState createSingleState() {
        return new SingleEvaluateClassifierPredictionsState();
    }

    public Class<? extends EvaluateClassifierPredictionsState> getSingleStateClass() {
        return SingleEvaluateClassifierPredictionsState.class;
    }

    public EvaluateClassifierPredictionsState createGroupedState() {
        return new GroupedEvaluateClassifierPredictionsState();
    }

    public Class<? extends EvaluateClassifierPredictionsState> getGroupedStateClass() {
        return GroupedEvaluateClassifierPredictionsState.class;
    }

    public static class SingleEvaluateClassifierPredictionsState
    implements EvaluateClassifierPredictionsState {
        private final Map<String, Integer> truePositives = new HashMap<String, Integer>();
        private final Map<String, Integer> falsePositives = new HashMap<String, Integer>();
        private final Map<String, Integer> falseNegatives = new HashMap<String, Integer>();
        private int memoryUsage;

        public long getEstimatedSize() {
            return (long)this.memoryUsage + 3L * HASH_MAP_SIZE;
        }

        @Override
        public void addMemoryUsage(int memory) {
            this.memoryUsage += memory;
        }

        @Override
        public Map<String, Integer> getTruePositives() {
            return this.truePositives;
        }

        @Override
        public Map<String, Integer> getFalsePositives() {
            return this.falsePositives;
        }

        @Override
        public Map<String, Integer> getFalseNegatives() {
            return this.falseNegatives;
        }
    }

    public static class GroupedEvaluateClassifierPredictionsState
    extends AbstractGroupedAccumulatorState
    implements EvaluateClassifierPredictionsState {
        private final ObjectBigArray<Map<String, Integer>> truePositives = new ObjectBigArray();
        private final ObjectBigArray<Map<String, Integer>> falsePositives = new ObjectBigArray();
        private final ObjectBigArray<Map<String, Integer>> falseNegatives = new ObjectBigArray();
        private long memoryUsage;

        @Override
        public void addMemoryUsage(int memory) {
            this.memoryUsage += (long)memory;
        }

        @Override
        public Map<String, Integer> getTruePositives() {
            if (this.truePositives.get(this.getGroupId()) == null) {
                this.truePositives.set(this.getGroupId(), new HashMap());
                this.memoryUsage += HASH_MAP_SIZE;
            }
            return (Map)this.truePositives.get(this.getGroupId());
        }

        @Override
        public Map<String, Integer> getFalsePositives() {
            if (this.falsePositives.get(this.getGroupId()) == null) {
                this.falsePositives.set(this.getGroupId(), new HashMap());
                this.memoryUsage += HASH_MAP_SIZE;
            }
            return (Map)this.falsePositives.get(this.getGroupId());
        }

        @Override
        public Map<String, Integer> getFalseNegatives() {
            if (this.falseNegatives.get(this.getGroupId()) == null) {
                this.falseNegatives.set(this.getGroupId(), new HashMap());
                this.memoryUsage += HASH_MAP_SIZE;
            }
            return (Map)this.falseNegatives.get(this.getGroupId());
        }

        public void ensureCapacity(long size) {
            this.truePositives.ensureCapacity(size);
            this.falsePositives.ensureCapacity(size);
            this.falseNegatives.ensureCapacity(size);
        }

        public long getEstimatedSize() {
            return this.memoryUsage + this.truePositives.sizeOf() + this.falsePositives.sizeOf() + this.falseNegatives.sizeOf();
        }
    }
}

