/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.ClassifierFeatureTransformer;
import com.facebook.presto.ml.Dataset;
import com.facebook.presto.ml.FeatureUnitNormalizer;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.LearnState;
import com.facebook.presto.ml.LibSvmUtils;
import com.facebook.presto.ml.ModelUtils;
import com.facebook.presto.ml.SvmClassifier;
import com.facebook.presto.ml.type.ClassifierType;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import java.util.Map;

@AggregationFunction(value="learn_libsvm_classifier", decomposable=false)
public final class LearnLibSvmClassifierAggregation {
    private LearnLibSvmClassifierAggregation() {
    }

    @InputFunction
    public static void input(LearnState state, @SqlType(value="bigint") long label, @SqlType(value="map<bigint,double>") Slice features, @SqlType(value="varchar") Slice parameters) {
        LearnLibSvmClassifierAggregation.input(state, (double)label, features, parameters);
    }

    @InputFunction
    public static void input(LearnState state, @SqlType(value="double") double label, @SqlType(value="map<bigint,double>") Slice features, @SqlType(value="varchar") Slice parameters) {
        state.getLabels().add(label);
        FeatureVector featureVector = ModelUtils.toFeatures(features);
        state.addMemoryUsage(featureVector.getEstimatedSize());
        state.getFeatureVectors().add(featureVector);
        state.setParameters(parameters);
    }

    @CombineFunction
    public static void combine(LearnState state, LearnState otherState) {
        throw new UnsupportedOperationException("LEARN must run on a single machine");
    }

    @OutputFunction(value="Classifier<bigint>")
    public static void output(LearnState state, BlockBuilder out) {
        Dataset dataset = new Dataset(state.getLabels(), state.getFeatureVectors(), (Map<Integer, String>)state.getLabelEnumeration().inverse());
        ClassifierFeatureTransformer model = new ClassifierFeatureTransformer(new SvmClassifier(LibSvmUtils.parseParameters(state.getParameters().toStringUtf8())), new FeatureUnitNormalizer());
        model.train(dataset);
        ClassifierType.BIGINT_CLASSIFIER.writeSlice(out, ModelUtils.serialize(model));
    }
}

