/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.plugin.memory.MemoryConfig;
import com.facebook.presto.plugin.memory.MemoryConnector;
import com.facebook.presto.plugin.memory.MemoryConnectorId;
import com.facebook.presto.plugin.memory.MemoryMetadata;
import com.facebook.presto.plugin.memory.MemoryPageSinkProvider;
import com.facebook.presto.plugin.memory.MemoryPageSourceProvider;
import com.facebook.presto.plugin.memory.MemoryPagesStore;
import com.facebook.presto.plugin.memory.MemorySplitManager;
import com.facebook.presto.spi.NodeManager;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Objects;

public class MemoryModule
implements Module {
    private final String connectorId;
    private final TypeManager typeManager;
    private final NodeManager nodeManager;

    public MemoryModule(String connectorId, TypeManager typeManager, NodeManager nodeManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
        binder.bind(MemoryConnector.class).in(Scopes.SINGLETON);
        binder.bind(MemoryConnectorId.class).toInstance((Object)new MemoryConnectorId(this.connectorId));
        binder.bind(MemoryMetadata.class).in(Scopes.SINGLETON);
        binder.bind(MemorySplitManager.class).in(Scopes.SINGLETON);
        binder.bind(MemoryPagesStore.class).in(Scopes.SINGLETON);
        binder.bind(MemoryPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(MemoryPageSinkProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MemoryConfig.class);
    }
}

