/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MemoryTrackingContext {
    private final AggregatedMemoryContext userAggregateMemoryContext;
    private final AggregatedMemoryContext revocableAggregateMemoryContext;
    private final AggregatedMemoryContext systemAggregateMemoryContext;
    private final LocalMemoryContext userLocalMemoryContext;
    private final LocalMemoryContext revocableLocalMemoryContext;
    private final LocalMemoryContext systemLocalMemoryContext;

    public MemoryTrackingContext(AggregatedMemoryContext userAggregateMemoryContext, AggregatedMemoryContext revocableAggregateMemoryContext, AggregatedMemoryContext systemAggregateMemoryContext) {
        this.userAggregateMemoryContext = Objects.requireNonNull(userAggregateMemoryContext, "userAggregateMemoryContext is null");
        this.revocableAggregateMemoryContext = Objects.requireNonNull(revocableAggregateMemoryContext, "revocableAggregateMemoryContext is null");
        this.systemAggregateMemoryContext = Objects.requireNonNull(systemAggregateMemoryContext, "systemAggregateMemoryContext is null");
        this.userLocalMemoryContext = userAggregateMemoryContext.newLocalMemoryContext();
        this.revocableLocalMemoryContext = revocableAggregateMemoryContext.newLocalMemoryContext();
        this.systemLocalMemoryContext = systemAggregateMemoryContext.newLocalMemoryContext();
    }

    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.userAggregateMemoryContext::close);
            closer.register(this.revocableAggregateMemoryContext::close);
            closer.register(this.systemAggregateMemoryContext::close);
            closer.register(this.userLocalMemoryContext::close);
            closer.register(this.revocableLocalMemoryContext::close);
            closer.register(this.systemLocalMemoryContext::close);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception closing memory tracking context", e);
        }
    }

    public LocalMemoryContext localUserMemoryContext() {
        return this.userLocalMemoryContext;
    }

    public LocalMemoryContext localSystemMemoryContext() {
        return this.systemLocalMemoryContext;
    }

    public LocalMemoryContext localRevocableMemoryContext() {
        return this.revocableLocalMemoryContext;
    }

    public LocalMemoryContext newUserMemoryContext() {
        return this.userAggregateMemoryContext.newLocalMemoryContext();
    }

    public LocalMemoryContext newSystemMemoryContext() {
        return this.systemAggregateMemoryContext.newLocalMemoryContext();
    }

    public AggregatedMemoryContext aggregateUserMemoryContext() {
        return this.userAggregateMemoryContext;
    }

    public AggregatedMemoryContext newAggregateSystemMemoryContext() {
        return this.systemAggregateMemoryContext.newAggregatedMemoryContext();
    }

    public long getUserMemory() {
        return this.userAggregateMemoryContext.getBytes();
    }

    public long getRevocableMemory() {
        return this.revocableAggregateMemoryContext.getBytes();
    }

    public long getSystemMemory() {
        return this.systemAggregateMemoryContext.getBytes();
    }

    public MemoryTrackingContext newMemoryTrackingContext() {
        return new MemoryTrackingContext(this.userAggregateMemoryContext.newAggregatedMemoryContext(), this.revocableAggregateMemoryContext.newAggregatedMemoryContext(), this.systemAggregateMemoryContext.newAggregatedMemoryContext());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("userAggregateMemoryContext", (Object)this.userAggregateMemoryContext).add("revocableAggregateMemoryContext", (Object)this.revocableAggregateMemoryContext).add("systemAggregateMemoryContext", (Object)this.systemAggregateMemoryContext).add("userLocalMemoryContext", (Object)this.userLocalMemoryContext).add("revocableLocalMemoryContext", (Object)this.revocableLocalMemoryContext).add("systemLocalMemoryContext", (Object)this.systemLocalMemoryContext).toString();
    }
}

