/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AbstractAggregatedMemoryContext;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SimpleLocalMemoryContext
implements LocalMemoryContext {
    private static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateFuture(null);
    private final AbstractAggregatedMemoryContext parentMemoryContext;
    @GuardedBy(value="this")
    private long usedBytes;
    @GuardedBy(value="this")
    private boolean closed;

    public SimpleLocalMemoryContext(AggregatedMemoryContext parentMemoryContext) {
        Verify.verify((boolean)(parentMemoryContext instanceof AbstractAggregatedMemoryContext));
        this.parentMemoryContext = (AbstractAggregatedMemoryContext)Objects.requireNonNull(parentMemoryContext, "parentMemoryContext is null");
    }

    @Override
    public synchronized long getBytes() {
        return this.usedBytes;
    }

    @Override
    public synchronized ListenableFuture<?> setBytes(long bytes) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"SimpleLocalMemoryContext is already closed");
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes cannot be negative");
        if (bytes == this.usedBytes) {
            return NOT_BLOCKED;
        }
        ListenableFuture<?> future = this.parentMemoryContext.updateBytes(bytes - this.usedBytes);
        this.usedBytes = bytes;
        return future;
    }

    @Override
    public synchronized boolean trySetBytes(long bytes) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"SimpleLocalMemoryContext is already closed");
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes cannot be negative");
        long delta = bytes - this.usedBytes;
        if (this.parentMemoryContext.tryUpdateBytes(delta)) {
            this.usedBytes = bytes;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public synchronized void transferMemory(LocalMemoryContext to) {
        Preconditions.checkArgument((boolean)(to instanceof SimpleLocalMemoryContext), (Object)"to must be an instance of SimpleLocalMemoryContext");
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
        SimpleLocalMemoryContext target = (SimpleLocalMemoryContext)to;
        this.checkMemoryContextState(target);
        for (AbstractAggregatedMemoryContext parent = this.parentMemoryContext; parent != null && parent != target.parentMemoryContext; parent = parent.getParent()) {
            parent.addBytes(-this.usedBytes);
        }
        target.addBytes(this.usedBytes);
        this.usedBytes = 0L;
    }

    private void checkMemoryContextState(SimpleLocalMemoryContext target) {
        AbstractAggregatedMemoryContext parent;
        for (parent = this.parentMemoryContext; parent != null && parent != target.parentMemoryContext; parent = parent.getParent()) {
        }
        Preconditions.checkState((parent != null ? 1 : 0) != 0, (Object)"memory context state is corrupt");
    }

    private synchronized void addBytes(long bytes) {
        this.usedBytes = AbstractAggregatedMemoryContext.addExact(this.usedBytes, bytes);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.parentMemoryContext.updateBytes(-this.usedBytes);
        this.usedBytes = 0L;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("usedBytes", this.usedBytes).toString();
    }
}

