/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static int hashPosition(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        return type.hash(block, position);
    }

    public static boolean positionEqualsPosition(Type type, Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftIsNull = leftBlock.isNull(leftPosition);
        boolean rightIsNull = rightBlock.isNull(rightPosition);
        if (leftIsNull || rightIsNull) {
            return leftIsNull && rightIsNull;
        }
        return type.equalTo(leftBlock, leftPosition, rightBlock, rightPosition);
    }

    public static List<Type> resolveTypes(List<TypeSignature> typeNames, TypeManager typeManager) {
        return (List)typeNames.stream().map(type -> (Type)Preconditions.checkNotNull((Object)typeManager.getType(type), (String)"Type '%s' not found", (Object[])new Object[]{type})).collect(ImmutableCollectors.toImmutableList());
    }

    public static TypeSignature parameterizedTypeName(String base, TypeSignature ... argumentNames) {
        return new TypeSignature(base, (List)ImmutableList.copyOf((Object[])argumentNames), (List)ImmutableList.of());
    }

    public static int getHashPosition(List<? extends Type> hashTypes, Block[] hashBlocks, int position) {
        int[] hashChannels = new int[hashBlocks.length];
        for (int i = 0; i < hashBlocks.length; ++i) {
            hashChannels[i] = i;
        }
        InterpretedHashGenerator hashGenerator = new InterpretedHashGenerator((List<Type>)ImmutableList.copyOf(hashTypes), hashChannels);
        Page page = new Page(hashBlocks);
        return hashGenerator.hashPosition(position, page);
    }

    public static Block getHashBlock(List<? extends Type> hashTypes, Block ... hashBlocks) {
        Preconditions.checkArgument((hashTypes.size() == hashBlocks.length ? 1 : 0) != 0);
        int[] hashChannels = new int[hashBlocks.length];
        for (int i = 0; i < hashBlocks.length; ++i) {
            hashChannels[i] = i;
        }
        InterpretedHashGenerator hashGenerator = new InterpretedHashGenerator((List<Type>)ImmutableList.copyOf(hashTypes), hashChannels);
        int positionCount = hashBlocks[0].getPositionCount();
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
        Page page = new Page(hashBlocks);
        for (int i = 0; i < positionCount; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)hashGenerator.hashPosition(i, page));
        }
        return builder.build();
    }

    public static Page getHashPage(Page page, List<? extends Type> types, List<Integer> hashChannels) {
        Block[] blocks = Arrays.copyOf(page.getBlocks(), page.getChannelCount() + 1);
        ImmutableList.Builder hashTypes = ImmutableList.builder();
        Block[] hashBlocks = new Block[hashChannels.size()];
        int hashBlockIndex = 0;
        for (int channel : hashChannels) {
            hashTypes.add((Object)types.get(channel));
            hashBlocks[hashBlockIndex++] = blocks[channel];
        }
        blocks[page.getChannelCount()] = TypeUtils.getHashBlock((List<? extends Type>)hashTypes.build(), hashBlocks);
        return new Page(blocks);
    }
}

