/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public final class TypeJsonUtils {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private static final CollectionType COLLECTION_TYPE = OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, Object.class);

    private TypeJsonUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object stackRepresentationToObject(ConnectorSession session, Slice value, Type type) {
        if (value == null) {
            return null;
        }
        try (JsonParser jsonParser = JSON_FACTORY.createJsonParser((InputStream)value.getInput());){
            jsonParser.nextToken();
            Object object = TypeJsonUtils.stackRepresentationToObjectHelper(session, jsonParser, type);
            return object;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Object stackRepresentationToObjectHelper(ConnectorSession session, JsonParser parser, Type type) throws IOException {
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (type instanceof ArrayType) {
            ArrayList<Object> list = new ArrayList<Object>();
            Preconditions.checkState((parser.getCurrentToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (Object)"Expected a json array");
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                list.add(TypeJsonUtils.stackRepresentationToObjectHelper(session, parser, ((ArrayType)type).getElementType()));
            }
            return Collections.unmodifiableList(list);
        }
        if (type instanceof MapType) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            Preconditions.checkState((parser.getCurrentToken() == JsonToken.START_OBJECT ? 1 : 0) != 0, (Object)"Expected a json object");
            while (parser.nextValue() != JsonToken.END_OBJECT) {
                Object key = TypeJsonUtils.mapKeyToObject(session, parser.getCurrentName(), ((MapType)type).getKeyType());
                Object value = TypeJsonUtils.stackRepresentationToObjectHelper(session, parser, ((MapType)type).getValueType());
                map.put(key, value);
            }
            return Collections.unmodifiableMap(map);
        }
        if (type instanceof RowType) {
            ArrayList<Object> list = new ArrayList<Object>();
            Preconditions.checkState((parser.getCurrentToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (Object)"Expected a json array");
            int field = 0;
            RowType rowType = (RowType)type;
            while (parser.nextValue() != JsonToken.END_ARRAY) {
                Preconditions.checkArgument((field < rowType.getFields().size() ? 1 : 0) != 0, (String)"Unexpected field for type %s", (Object[])new Object[]{type});
                Object value = TypeJsonUtils.stackRepresentationToObjectHelper(session, parser, rowType.getFields().get(field).getType());
                list.add(value);
                ++field;
            }
            Preconditions.checkArgument((field == rowType.getFields().size() ? 1 : 0) != 0, (String)"Expected %d fields for type %s", (Object[])new Object[]{rowType.getFields().size(), type});
            return Collections.unmodifiableList(list);
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, parser.getBooleanValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, parser.getLongValue());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, TypeJsonUtils.getDoubleValue(parser));
        } else if (type.getJavaType() == Slice.class) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)parser.getValueAsString()));
        }
        return type.getObjectValue(session, blockBuilder.build(), 0);
    }

    private static Object mapKeyToObject(ConnectorSession session, String jsonKey, Type type) {
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, Boolean.valueOf(jsonKey).booleanValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, Long.valueOf(jsonKey).longValue());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, Double.valueOf(jsonKey).doubleValue());
        } else if (type.getJavaType() == Slice.class) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)jsonKey));
        }
        return type.getObjectValue(session, blockBuilder.build(), 0);
    }

    public static List<Object> getObjectList(Slice slice) {
        try {
            return (List)OBJECT_MAPPER.readValue((InputStream)slice.getInput(), (JavaType)COLLECTION_TYPE);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    public static Block createBlock(Type type, Object element) {
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        Class javaType = type.getJavaType();
        if (element == null) {
            blockBuilder.appendNull();
        } else if (javaType == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)element).booleanValue());
        } else if (javaType == Long.TYPE) {
            type.writeLong(blockBuilder, ((Number)element).longValue());
        } else if (javaType == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Double)element).doubleValue());
        } else if (javaType == Slice.class) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)element.toString()));
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unexpected type %s", javaType.getName()));
        }
        return blockBuilder.build();
    }

    public static Object getValue(Block input, Type type, int position) {
        if (input.isNull(position)) {
            return null;
        }
        if (type.getJavaType() == Long.TYPE) {
            return type.getLong(input, position);
        }
        if (type.getJavaType() == Double.TYPE) {
            return type.getDouble(input, position);
        }
        if (type.getJavaType() == Slice.class) {
            return type.getObjectValue(null, input, position);
        }
        if (type.getJavaType() == Boolean.TYPE) {
            return type.getBoolean(input, position);
        }
        throw new IllegalArgumentException("Unsupported type: " + type.getJavaType().getSimpleName());
    }

    public static double getDoubleValue(JsonParser parser) throws IOException {
        double value;
        try {
            value = parser.getDoubleValue();
        }
        catch (JsonParseException e) {
            value = Double.parseDouble(parser.getValueAsString());
        }
        return value;
    }

    public static boolean canCastFromJson(Type type) {
        String baseType = type.getTypeSignature().getBase();
        if (baseType.equals("boolean") || baseType.equals("bigint") || baseType.equals("double") || baseType.equals("varchar")) {
            return true;
        }
        if (type instanceof ArrayType) {
            return TypeJsonUtils.canCastFromJson(((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            return TypeJsonUtils.canCastFromJson(((MapType)type).getKeyType()) && TypeJsonUtils.canCastFromJson(((MapType)type).getValueType());
        }
        return false;
    }
}

