/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.AbstractVariableWidthType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeJsonUtils;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RowType
extends AbstractVariableWidthType {
    private final List<RowField> fields;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private static final CollectionType COLLECTION_TYPE = OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, Object.class);

    public RowType(List<Type> fieldTypes, Optional<List<String>> fieldNames) {
        super(new TypeSignature("row", Lists.transform(fieldTypes, Type::getTypeSignature), (List)fieldNames.orElse((List<String>)ImmutableList.of()).stream().map(Object.class::cast).collect(ImmutableCollectors.toImmutableList())), Slice.class);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            int index = i;
            builder.add((Object)new RowField(fieldTypes.get(i), fieldNames.map(names -> (String)names.get(index))));
        }
        this.fields = builder.build();
    }

    public String getDisplayName() {
        ArrayList<String> fields = new ArrayList<String>();
        for (int i = 0; i < this.fields.size(); ++i) {
            RowField field = this.fields.get(i);
            if (field.getName().isPresent()) {
                fields.add(field.getName() + " " + field.getType().getDisplayName());
                continue;
            }
            fields.add(field.getType().getDisplayName());
        }
        return "ROW(" + Joiner.on((String)", ").join(fields) + ")";
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = block.getSlice(position, 0, block.getLength(position));
        return TypeJsonUtils.stackRepresentationToObject(session, slice, (Type)this);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getLength(position));
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return new VariableWidthBlockBuilder(blockBuilderStatus);
    }

    public List<Type> getTypeParameters() {
        return (List)this.fields.stream().map(RowField::getType).collect(ImmutableCollectors.toImmutableList());
    }

    public List<RowField> getFields() {
        return this.fields;
    }

    public boolean isComparable() {
        return Iterables.all(this.fields, (Predicate)new Predicate<RowField>(){

            public boolean apply(RowField field) {
                return field.getType().isComparable();
            }
        });
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        List<Object> leftRow = this.extractElements(leftBlock, leftPosition);
        List<Object> rightRow = this.extractElements(rightBlock, rightPosition);
        int nFields = leftRow.size();
        for (int i = 0; i < nFields; ++i) {
            Object leftElement = leftRow.get(i);
            Object rightElement = rightRow.get(i);
            RowType.checkElementNotNull(leftElement);
            RowType.checkElementNotNull(rightElement);
            Type fieldType = this.fields.get(i).getType();
            if (fieldType.equalTo(TypeJsonUtils.createBlock(fieldType, leftElement), 0, TypeJsonUtils.createBlock(fieldType, rightElement), 0)) continue;
            return false;
        }
        return true;
    }

    public int hash(Block block, int position) {
        List<Object> elements = this.extractElements(block, position);
        int result = 1;
        int nFields = elements.size();
        for (int i = 0; i < nFields; ++i) {
            Object element = elements.get(i);
            RowType.checkElementNotNull(element);
            Type elementType = this.fields.get(i).getType();
            result = 31 * result + elementType.hash(TypeJsonUtils.createBlock(elementType, element), 0);
        }
        return result;
    }

    private static void checkElementNotNull(Object element) {
        if (element == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ROW comparison not supported for rows with null elements");
        }
    }

    private List<Object> extractElements(Block block, int position) {
        Slice value = this.getSlice(block, position);
        try {
            return (List)OBJECT_MAPPER.readValue(value.getBytes(), (JavaType)COLLECTION_TYPE);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, String.format("Bad native value, '%s'", value.toStringUtf8()), (Throwable)e);
        }
    }

    public static class RowField {
        private final Type type;
        private final Optional<String> name;

        public RowField(Type type, Optional<String> name) {
            this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
            this.name = (Optional)Preconditions.checkNotNull(name, (Object)"name is null");
        }

        public Type getType() {
            return this.type;
        }

        public Optional<String> getName() {
            return this.name;
        }
    }
}

