/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.operator.scalar.RowFieldAccessor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ParametricType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public final class RowParametricType
implements ParametricType {
    public static final RowParametricType ROW = new RowParametricType();

    private RowParametricType() {
    }

    @Override
    public String getName() {
        return "row";
    }

    public RowType createType(List<Type> types, List<Object> literals) {
        Preconditions.checkArgument((!types.isEmpty() ? 1 : 0) != 0, (Object)"types is empty");
        if (literals.isEmpty()) {
            return new RowType(types, Optional.empty());
        }
        Preconditions.checkArgument((types.size() == literals.size() ? 1 : 0) != 0, (Object)"types and literals must be matched in size");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object literal : literals) {
            builder.add((Object)Types.checkType(literal, String.class, "literal"));
        }
        return new RowType(types, Optional.of(builder.build()));
    }

    public List<ParametricFunction> createFunctions(Type type) {
        RowType rowType = Types.checkType(type, RowType.class, "type");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RowType.RowField field : rowType.getFields()) {
            field.getName().ifPresent(name -> builder.add((Object)new RowFieldAccessor(rowType, field.getName().get())));
        }
        return builder.build();
    }
}

