/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class DoubleOperators {
    private DoubleOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="double")
    public static double add(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="double")
    public static double subtract(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="double")
    public static double multiply(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="double")
    public static double divide(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        try {
            return left / right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="double")
    public static double modulus(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        try {
            return left % right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="double")
    public static double negate(@SqlType(value="double") double value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="double") double value, @SqlType(value="double") double min, @SqlType(value="double") double max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="double") double value) {
        return value != 0.0;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToLong(@SqlType(value="double") double value) {
        return (long)MathFunctions.round(value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToVarchar(@SqlType(value="double") double value) {
        return Slices.copiedBuffer((String)String.valueOf(value), (Charset)StandardCharsets.UTF_8);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="double") double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }
}

