/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.AbstractVariableWidthType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.RawSliceSerializer;
import com.facebook.presto.type.TypeJsonUtils;
import com.facebook.presto.type.TypeUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ArrayType
extends AbstractVariableWidthType {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new SliceSerializer()));
    private static final ObjectMapper RAW_SLICE_OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new RawSliceSerializer()));
    private final Type elementType;

    public ArrayType(Type elementType) {
        super(TypeUtils.parameterizedTypeName("array", elementType.getTypeSignature()), Slice.class);
        this.elementType = (Type)Preconditions.checkNotNull((Object)elementType, (Object)"elementType is null");
    }

    public Type getElementType() {
        return this.elementType;
    }

    public static Slice toStackRepresentation(List<?> values) {
        try {
            return Slices.utf8Slice((String)OBJECT_MAPPER.writeValueAsString(values));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Slice rawSlicesToStackRepresentation(List<Slice> values) {
        try {
            return Slices.utf8Slice((String)RAW_SLICE_OBJECT_MAPPER.writeValueAsString(values));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean isComparable() {
        return this.elementType.isComparable();
    }

    public boolean isOrderable() {
        return this.elementType.isOrderable();
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return this.compareTo(leftBlock, leftPosition, rightBlock, rightPosition) == 0;
    }

    public int hash(Block block, int position) {
        Slice value = this.getSlice(block, position);
        List<Object> array = TypeJsonUtils.getObjectList(value);
        ArrayList<Integer> hashArray = new ArrayList<Integer>();
        for (Object element : array) {
            ArrayType.checkElementNotNull(element);
            hashArray.add(this.elementType.hash(TypeJsonUtils.createBlock(this.elementType, element), 0));
        }
        return Objects.hash(hashArray);
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int index;
        Slice leftSlice = this.getSlice(leftBlock, leftPosition);
        Slice rightSlice = this.getSlice(rightBlock, rightPosition);
        List<Object> leftArray = TypeJsonUtils.getObjectList(leftSlice);
        List<Object> rightArray = TypeJsonUtils.getObjectList(rightSlice);
        int len = Math.min(leftArray.size(), rightArray.size());
        for (index = 0; index < len; ++index) {
            ArrayType.checkElementNotNull(leftArray.get(index));
            ArrayType.checkElementNotNull(rightArray.get(index));
            int comparison = this.elementType.compareTo(TypeJsonUtils.createBlock(this.elementType, leftArray.get(index)), 0, TypeJsonUtils.createBlock(this.elementType, rightArray.get(index)), 0);
            if (comparison == 0) continue;
            return comparison;
        }
        if (index == len) {
            return leftArray.size() - rightArray.size();
        }
        return 0;
    }

    private static void checkElementNotNull(Object element) {
        if (element == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ARRAY comparison not supported for arrays with null elements");
        }
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = block.getSlice(position, 0, block.getLength(position));
        return TypeJsonUtils.stackRepresentationToObject(session, slice, (Type)this);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getLength(position));
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return new VariableWidthBlockBuilder(blockBuilderStatus);
    }

    public List<Type> getTypeParameters() {
        return ImmutableList.of((Object)this.getElementType());
    }
}

