/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.testing.RunLengthBlockEncoding;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public class RunLengthEncodedBlock
implements Block {
    private final Block value;
    private final int positionCount;

    public RunLengthEncodedBlock(Block value, int positionCount) {
        this.value = (Block)Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkArgument((value.getPositionCount() == 1 ? 1 : 0) != 0, (String)"Expected value to contain a single position but has %s positions", (Object[])new Object[]{value.getPositionCount()});
        Preconditions.checkArgument((!(value instanceof RunLengthEncodedBlock) ? 1 : 0) != 0, (String)"Value can not be an instance of a %s", (Object[])new Object[]{this.getClass().getName()});
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        this.positionCount = (Integer)Preconditions.checkNotNull((Object)positionCount, (Object)"positionCount is null");
    }

    public Block getValue() {
        return this.value;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public int getSizeInBytes() {
        return this.value.getSizeInBytes();
    }

    public RunLengthBlockEncoding getEncoding() {
        return new RunLengthBlockEncoding(this.value.getEncoding());
    }

    public Block getRegion(int positionOffset, int length) {
        Preconditions.checkPositionIndexes((int)positionOffset, (int)(positionOffset + length), (int)this.positionCount);
        return new RunLengthEncodedBlock(this.value, length);
    }

    public int getLength(int position) {
        return this.value.getLength(0);
    }

    public byte getByte(int position, int offset) {
        return this.value.getByte(0, offset);
    }

    public short getShort(int position, int offset) {
        return this.value.getShort(0, offset);
    }

    public int getInt(int position, int offset) {
        return this.value.getInt(0, offset);
    }

    public long getLong(int position, int offset) {
        return this.value.getLong(0, offset);
    }

    public float getFloat(int position, int offset) {
        return this.value.getFloat(0, offset);
    }

    public double getDouble(int position, int offset) {
        return this.value.getDouble(0, offset);
    }

    public Slice getSlice(int position, int offset, int length) {
        return this.value.getSlice(0, offset, length);
    }

    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.value.bytesEqual(0, offset, otherSlice, otherOffset, length);
    }

    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.value.bytesCompare(0, offset, length, otherSlice, otherOffset, otherLength);
    }

    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.value.writeBytesTo(0, offset, length, blockBuilder);
    }

    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.value.equals(0, offset, otherBlock, otherPosition, otherOffset, length);
    }

    public int hash(int position, int offset, int length) {
        return this.value.hash(0, offset, length);
    }

    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.value.compareTo(0, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        return this.value;
    }

    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.value.isNull(0);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("positionCount", this.positionCount).toString();
    }

    public void assureLoaded() {
        this.value.assureLoaded();
    }

    private void checkReadablePosition(int position) {
        Preconditions.checkArgument((position >= 0 && position < this.positionCount ? 1 : 0) != 0, (Object)"position is not valid");
    }
}

