/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational.optimizer;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.Signatures;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;

public class ExpressionOptimizer {
    private final FunctionRegistry registry;
    private final TypeManager typeManager;
    private final ConnectorSession session;

    public ExpressionOptimizer(FunctionRegistry registry, TypeManager typeManager, Session session) {
        this.registry = registry;
        this.typeManager = typeManager;
        this.session = session.toConnectorSession();
    }

    public RowExpression optimize(RowExpression expression) {
        return expression.accept(new Visitor(), null);
    }

    private class Visitor
    implements RowExpressionVisitor<Void, RowExpression> {
        private Visitor() {
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            return reference;
        }

        @Override
        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        @Override
        public RowExpression visitCall(CallExpression call, Void context) {
            FunctionInfo function;
            Signature signature = call.getSignature();
            if (signature.getName().equals(Signatures.CAST)) {
                if (call.getArguments().get(0).getType().equals((Object)UnknownType.UNKNOWN)) {
                    return Expressions.constantNull(call.getType());
                }
                function = ExpressionOptimizer.this.registry.getCoercion(call.getArguments().get(0).getType(), call.getType());
            } else {
                switch (signature.getName()) {
                    case "IF": 
                    case "NULL_IF": 
                    case "SWITCH": 
                    case "TRY_CAST": 
                    case "IS_NULL": 
                    case "IS_DISTINCT_FROM": 
                    case "COALESCE": 
                    case "AND": 
                    case "OR": 
                    case "IN": {
                        return call;
                    }
                }
                function = ExpressionOptimizer.this.registry.getExactFunction(signature);
                if (function == null) {
                    function = ExpressionOptimizer.this.registry.resolveFunction(QualifiedName.of((String)signature.getName(), (String[])new String[0]), signature.getArgumentTypes(), false);
                }
            }
            List arguments = (List)call.getArguments().stream().map(argument -> argument.accept(this, context)).collect(ImmutableCollectors.toImmutableList());
            if (Iterables.all((Iterable)arguments, (Predicate)Predicates.instanceOf(ConstantExpression.class)) && function.isDeterministic()) {
                MethodHandle method = function.getMethodHandle();
                if (method.type().parameterCount() > 0 && method.type().parameterType(0) == ConnectorSession.class) {
                    method = method.bindTo(ExpressionOptimizer.this.session);
                }
                ArrayList<Object> constantArguments = new ArrayList<Object>();
                for (RowExpression argument2 : arguments) {
                    Object value = ((ConstantExpression)argument2).getValue();
                    if (value == null) {
                        return Expressions.constantNull(call.getType());
                    }
                    constantArguments.add(value);
                }
                try {
                    return Expressions.constant(method.invokeWithArguments(constantArguments), call.getType());
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw Throwables.propagate((Throwable)e);
                }
            }
            return Expressions.call(signature, ExpressionOptimizer.this.typeManager.getType(signature.getReturnType()), arguments);
        }
    }
}

