/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class CallExpression
extends RowExpression {
    private final Signature signature;
    private final Type returnType;
    private final List<RowExpression> arguments;

    public CallExpression(Signature signature, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkNotNull((Object)signature, (Object)"signature is null");
        Preconditions.checkNotNull(arguments, (Object)"arguments is null");
        Preconditions.checkNotNull((Object)returnType, (Object)"returnType is null");
        this.signature = signature;
        this.returnType = returnType;
        this.arguments = ImmutableList.copyOf(arguments);
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Type getType() {
        return this.returnType;
    }

    public List<RowExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public String toString() {
        return this.signature.getName() + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.signature, this.arguments);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CallExpression other = (CallExpression)obj;
        return Objects.equals(this.signature, other.signature) && Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public <C, R> R accept(RowExpressionVisitor<C, R> visitor, C context) {
        return visitor.visitCall(this, context);
    }
}

