/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.WindowFrame;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WindowNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> partitionBy;
    private final List<Symbol> orderBy;
    private final Map<Symbol, SortOrder> orderings;
    private final Frame frame;
    private final Map<Symbol, FunctionCall> windowFunctions;
    private final Map<Symbol, Signature> functionHandles;
    private final Optional<Symbol> hashSymbol;

    @JsonCreator
    public WindowNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="partitionBy") List<Symbol> partitionBy, @JsonProperty(value="orderBy") List<Symbol> orderBy, @JsonProperty(value="orderings") Map<Symbol, SortOrder> orderings, @JsonProperty(value="frame") Frame frame, @JsonProperty(value="windowFunctions") Map<Symbol, FunctionCall> windowFunctions, @JsonProperty(value="signatures") Map<Symbol, Signature> signatures, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol) {
        super(id);
        Preconditions.checkNotNull((Object)source, (Object)"source is null");
        Preconditions.checkNotNull(partitionBy, (Object)"partitionBy is null");
        Preconditions.checkNotNull(orderBy, (Object)"orderBy is null");
        Preconditions.checkArgument((orderings.size() == orderBy.size() ? 1 : 0) != 0, (Object)"orderBy and orderings sizes don't match");
        Preconditions.checkNotNull((Object)frame, (Object)"frame is null");
        Preconditions.checkNotNull(windowFunctions, (Object)"windowFunctions is null");
        Preconditions.checkNotNull(signatures, (Object)"signatures is null");
        Preconditions.checkArgument((boolean)windowFunctions.keySet().equals(signatures.keySet()), (Object)"windowFunctions does not match signatures");
        Preconditions.checkNotNull(hashSymbol, (Object)"hashSymbol is null");
        this.source = source;
        this.partitionBy = ImmutableList.copyOf(partitionBy);
        this.orderBy = ImmutableList.copyOf(orderBy);
        this.orderings = ImmutableMap.copyOf(orderings);
        this.frame = frame;
        this.windowFunctions = ImmutableMap.copyOf(windowFunctions);
        this.functionHandles = ImmutableMap.copyOf(signatures);
        this.hashSymbol = hashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), this.windowFunctions.keySet()));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public List<Symbol> getOrderBy() {
        return this.orderBy;
    }

    @JsonProperty
    public Map<Symbol, SortOrder> getOrderings() {
        return this.orderings;
    }

    @JsonProperty
    public Frame getFrame() {
        return this.frame;
    }

    @JsonProperty
    public Map<Symbol, FunctionCall> getWindowFunctions() {
        return this.windowFunctions;
    }

    @JsonProperty
    public Map<Symbol, Signature> getSignatures() {
        return this.functionHandles;
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitWindow(this, context);
    }

    @Immutable
    public static class Frame {
        private final WindowFrame.Type type;
        private final FrameBound.Type startType;
        private final Optional<Symbol> startValue;
        private final FrameBound.Type endType;
        private final Optional<Symbol> endValue;

        @JsonCreator
        public Frame(@JsonProperty(value="type") WindowFrame.Type type, @JsonProperty(value="startType") FrameBound.Type startType, @JsonProperty(value="startValue") Optional<Symbol> startValue, @JsonProperty(value="endType") FrameBound.Type endType, @JsonProperty(value="endValue") Optional<Symbol> endValue) {
            this.startType = (FrameBound.Type)Preconditions.checkNotNull((Object)startType, (Object)"startType is null");
            this.startValue = (Optional)Preconditions.checkNotNull(startValue, (Object)"startValue is null");
            this.endType = (FrameBound.Type)Preconditions.checkNotNull((Object)endType, (Object)"endType is null");
            this.endValue = (Optional)Preconditions.checkNotNull(endValue, (Object)"endValue is null");
            this.type = (WindowFrame.Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        }

        @JsonProperty
        public WindowFrame.Type getType() {
            return this.type;
        }

        @JsonProperty
        public FrameBound.Type getStartType() {
            return this.startType;
        }

        @JsonProperty
        public Optional<Symbol> getStartValue() {
            return this.startValue;
        }

        @JsonProperty
        public FrameBound.Type getEndType() {
            return this.endType;
        }

        @JsonProperty
        public Optional<Symbol> getEndValue() {
            return this.endValue;
        }
    }
}

