/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OutputNode
extends PlanNode {
    private final PlanNode source;
    private final List<String> columnNames;
    private final List<Symbol> outputs;

    @JsonCreator
    public OutputNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="columns") List<String> columnNames, @JsonProperty(value="outputs") List<Symbol> outputs) {
        super(id);
        Preconditions.checkNotNull((Object)source, (Object)"source is null");
        Preconditions.checkNotNull(columnNames, (Object)"columnNames is null");
        Preconditions.checkArgument((columnNames.size() == outputs.size() ? 1 : 0) != 0, (Object)"columnNames and assignments sizes don't match");
        this.source = source;
        this.columnNames = columnNames;
        this.outputs = ImmutableList.copyOf(outputs);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty(value="columns")
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitOutput(this, context);
    }
}

