/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IndexJoinNode
extends PlanNode {
    private final Type type;
    private final PlanNode probeSource;
    private final PlanNode indexSource;
    private final List<EquiJoinClause> criteria;
    private final Optional<Symbol> probeHashSymbol;
    private final Optional<Symbol> indexHashSymbol;

    @JsonCreator
    public IndexJoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="probeSource") PlanNode probeSource, @JsonProperty(value="indexSource") PlanNode indexSource, @JsonProperty(value="criteria") List<EquiJoinClause> criteria, @JsonProperty(value="probeHashSymbol") Optional<Symbol> probeHashSymbol, @JsonProperty(value="indexHashSymbol") Optional<Symbol> indexHashSymbol) {
        super(id);
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null"));
        this.probeSource = (PlanNode)Preconditions.checkNotNull((Object)probeSource, (Object)"probeSource is null");
        this.indexSource = (PlanNode)Preconditions.checkNotNull((Object)indexSource, (Object)"indexSource is null");
        this.criteria = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(criteria, (Object)"criteria is null")));
        this.probeHashSymbol = (Optional)Preconditions.checkNotNull(probeHashSymbol, (Object)"probeHashSymbol is null");
        this.indexHashSymbol = (Optional)Preconditions.checkNotNull(indexHashSymbol, (Object)"indexHashSymbol is null");
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="probeSource")
    public PlanNode getProbeSource() {
        return this.probeSource;
    }

    @JsonProperty(value="indexSource")
    public PlanNode getIndexSource() {
        return this.indexSource;
    }

    @JsonProperty(value="criteria")
    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @JsonProperty(value="probeHashSymbol")
    public Optional<Symbol> getProbeHashSymbol() {
        return this.probeHashSymbol;
    }

    @JsonProperty(value="indexHashSymbol")
    public Optional<Symbol> getIndexHashSymbol() {
        return this.indexHashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.probeSource, (Object)this.indexSource);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.probeSource.getOutputSymbols()).addAll(this.indexSource.getOutputSymbols()).build();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitIndexJoin(this, context);
    }

    public static class EquiJoinClause {
        private final Symbol probe;
        private final Symbol index;

        @JsonCreator
        public EquiJoinClause(@JsonProperty(value="probe") Symbol probe, @JsonProperty(value="index") Symbol index) {
            this.probe = (Symbol)Preconditions.checkNotNull((Object)probe, (Object)"probe is null");
            this.index = (Symbol)Preconditions.checkNotNull((Object)index, (Object)"index is null");
        }

        @JsonProperty(value="probe")
        public Symbol getProbe() {
            return this.probe;
        }

        @JsonProperty(value="index")
        public Symbol getIndex() {
            return this.index;
        }
    }

    public static enum Type {
        INNER("Inner"),
        SOURCE_OUTER("SourceOuter");

        private final String joinLabel;

        private Type(String joinLabel) {
            this.joinLabel = joinLabel;
        }

        public String getJoinLabel() {
            return this.joinLabel;
        }
    }
}

