/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Partition;
import com.facebook.presto.metadata.PartitionResult;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.EffectivePredicateExtractor;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.LookupSymbolResolver;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PredicatePushDown
extends PlanOptimizer {
    private static final Logger log = Logger.get(PredicatePushDown.class);
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final SplitManager splitManager;

    public PredicatePushDown(Metadata metadata, SqlParser sqlParser, SplitManager splitManager) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
        this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(symbolAllocator, idAllocator, this.metadata, this.sqlParser, this.splitManager, session), plan, BooleanLiteral.TRUE_LITERAL);
    }

    private static class Rewriter
    extends PlanRewriter<Expression> {
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final SplitManager splitManager;
        private final Session session;

        private Rewriter(SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser sqlParser, SplitManager splitManager, Session session) {
            this.symbolAllocator = (SymbolAllocator)Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
            this.idAllocator = (PlanNodeIdAllocator)Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
            this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
            this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
            this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
            this.session = (Session)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        }

        @Override
        public PlanNode visitPlan(PlanNode node, PlanRewriter.RewriteContext<Expression> context) {
            PlanNode rewrittenNode = context.defaultRewrite(node, (Expression)BooleanLiteral.TRUE_LITERAL);
            if (!context.get().equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, context.get());
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitProject(ProjectNode node, PlanRewriter.RewriteContext<Expression> context) {
            Set deterministicSymbols = node.getAssignments().entrySet().stream().filter(entry -> DeterminismEvaluator.isDeterministic((Expression)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            Predicate<Expression> deterministic = conjunct -> DependencyExtractor.extractAll(conjunct).stream().allMatch(deterministicSymbols::contains);
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(deterministic));
            PlanNode rewrittenNode = context.defaultRewrite(node, ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(node.getAssignments()), (Expression)ExpressionUtils.combineConjuncts((Iterable<Expression>)conjuncts.get(true))));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, ExpressionUtils.combineConjuncts((Iterable<Expression>)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, PlanRewriter.RewriteContext<Expression> context) {
            Preconditions.checkState((!DependencyExtractor.extractUnique(context.get()).contains(node.getMarkerSymbol()) ? 1 : 0) != 0, (Object)"predicate depends on marker symbol");
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSort(SortNode node, PlanRewriter.RewriteContext<Expression> context) {
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitUnion(UnionNode node, PlanRewriter.RewriteContext<Expression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                Expression sourcePredicate = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(node.sourceSymbolMap(i)), (Expression)context.get());
                PlanNode source = node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new UnionNode(node.getId(), (List<PlanNode>)builder.build(), node.getSymbolMapping());
            }
            return node;
        }

        @Override
        public PlanNode visitFilter(FilterNode node, PlanRewriter.RewriteContext<Expression> context) {
            return context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(node.getPredicate(), context.get()));
        }

        @Override
        public PlanNode visitJoin(JoinNode node, PlanRewriter.RewriteContext<Expression> context) {
            Expression newJoinPredicate;
            Expression postJoinPredicate;
            Expression rightPredicate;
            Expression leftPredicate;
            Expression inheritedPredicate = context.get();
            boolean isCrossJoin = node.getType() == JoinNode.Type.CROSS;
            node = this.tryNormalizeToInnerJoin(node, inheritedPredicate);
            Expression leftEffectivePredicate = EffectivePredicateExtractor.extract(node.getLeft(), this.symbolAllocator.getTypes());
            Expression rightEffectivePredicate = EffectivePredicateExtractor.extract(node.getRight(), this.symbolAllocator.getTypes());
            Expression joinPredicate = Rewriter.extractJoinPredicate(node);
            switch (node.getType()) {
                case INNER: {
                    InnerJoinPushDownResult innerJoinPushDownResult = this.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = innerJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case LEFT: {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = this.processOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = joinPredicate;
                    break;
                }
                case RIGHT: {
                    OuterJoinPushDownResult rightOuterJoinPushDownResult = this.processOuterJoin(inheritedPredicate, rightEffectivePredicate, leftEffectivePredicate, joinPredicate, node.getRight().getOutputSymbols());
                    leftPredicate = rightOuterJoinPushDownResult.getInnerJoinPredicate();
                    rightPredicate = rightOuterJoinPushDownResult.getOuterJoinPredicate();
                    postJoinPredicate = rightOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = joinPredicate;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
                }
            }
            PlanNode leftSource = context.rewrite(node.getLeft(), leftPredicate);
            PlanNode rightSource = context.rewrite(node.getRight(), rightPredicate);
            PlanNode output = node;
            if (leftSource != node.getLeft() || rightSource != node.getRight() || !newJoinPredicate.equals((Object)joinPredicate) || isCrossJoin) {
                ImmutableList criteria = node.getCriteria();
                if (!newJoinPredicate.equals((Object)joinPredicate) || isCrossJoin) {
                    ImmutableMap.Builder leftProjections = ImmutableMap.builder();
                    leftProjections.putAll(node.getLeft().getOutputSymbols().stream().collect(Collectors.toMap(key -> key, Symbol::toQualifiedNameReference)));
                    ImmutableMap.Builder rightProjections = ImmutableMap.builder();
                    rightProjections.putAll(node.getRight().getOutputSymbols().stream().collect(Collectors.toMap(key -> key, Symbol::toQualifiedNameReference)));
                    Iterable simplifiedJoinConjuncts = Iterables.transform(ExpressionUtils.extractConjuncts(newJoinPredicate), this::simplifyExpression);
                    simplifiedJoinConjuncts = Iterables.filter((Iterable)simplifiedJoinConjuncts, (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.equalTo((Object)BooleanLiteral.TRUE_LITERAL)));
                    if (Iterables.isEmpty((Iterable)simplifiedJoinConjuncts)) {
                        simplifiedJoinConjuncts = ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new LongLiteral("0"), (Expression)new LongLiteral("0")));
                    }
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (Expression conjunct : simplifiedJoinConjuncts) {
                        Preconditions.checkState((boolean)Rewriter.joinEqualityExpression(node.getLeft().getOutputSymbols()).apply((Object)conjunct), (Object)"Expected join predicate to be a valid join equality");
                        ComparisonExpression equality = (ComparisonExpression)conjunct;
                        boolean alignedComparison = Iterables.all(DependencyExtractor.extractUnique(equality.getLeft()), (com.google.common.base.Predicate)Predicates.in(node.getLeft().getOutputSymbols()));
                        Expression leftExpression = alignedComparison ? equality.getLeft() : equality.getRight();
                        Expression rightExpression = alignedComparison ? equality.getRight() : equality.getLeft();
                        Symbol leftSymbol = this.symbolAllocator.newSymbol(leftExpression, this.extractType(leftExpression));
                        leftProjections.put((Object)leftSymbol, (Object)leftExpression);
                        Symbol rightSymbol = this.symbolAllocator.newSymbol(rightExpression, this.extractType(rightExpression));
                        rightProjections.put((Object)rightSymbol, (Object)rightExpression);
                        builder.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    }
                    leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, (Map<Symbol, Expression>)leftProjections.build());
                    rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, (Map<Symbol, Expression>)rightProjections.build());
                    criteria = builder.build();
                }
                output = new JoinNode(node.getId(), node.getType(), leftSource, rightSource, (List<JoinNode.EquiJoinClause>)criteria, node.getLeftHashSymbol(), node.getRightHashSymbol());
            }
            if (!postJoinPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                output = new FilterNode(this.idAllocator.getNextId(), output, postJoinPredicate);
            }
            return output;
        }

        private OuterJoinPushDownResult processOuterJoin(Expression inheritedPredicate, Expression outerEffectivePredicate, Expression innerEffectivePredicate, Expression joinPredicate, Collection<Symbol> outerSymbols) {
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(outerEffectivePredicate), (com.google.common.base.Predicate)Predicates.in(outerSymbols)), (Object)"outerEffectivePredicate must only contain symbols from outerSymbols");
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(innerEffectivePredicate), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerSymbols))), (Object)"innerEffectivePredicate must not contain symbols from outerSymbols");
            ImmutableList.Builder outerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder innerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder postJoinConjuncts = ImmutableList.builder();
            postJoinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic)));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            outerEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(outerEffectivePredicate);
            innerEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(innerEffectivePredicate);
            joinPredicate = ExpressionUtils.stripNonDeterministicConjuncts(joinPredicate);
            EqualityInference inheritedInference = EqualityInference.createEqualityInference(inheritedPredicate);
            EqualityInference outerInference = EqualityInference.createEqualityInference(inheritedPredicate, outerEffectivePredicate);
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(outerSymbols));
            Expression outerOnlyInheritedEqualities = ExpressionUtils.combineConjuncts(equalityPartition.getScopeEqualities());
            EqualityInference potentialNullSymbolInference = EqualityInference.createEqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, innerEffectivePredicate, joinPredicate);
            EqualityInference potentialNullSymbolInferenceWithoutInnerInferred = EqualityInference.createEqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, joinPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression outerRewritten = outerInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(outerSymbols));
                if (outerRewritten != null) {
                    outerPushdownConjuncts.add((Object)outerRewritten);
                    Expression innerRewritten = potentialNullSymbolInference.rewriteExpression(outerRewritten, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerSymbols)));
                    if (innerRewritten == null) continue;
                    innerPushdownConjuncts.add((Object)innerRewritten);
                    continue;
                }
                postJoinConjuncts.add((Object)conjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(ExpressionUtils.and(outerEffectivePredicate, joinPredicate))) {
                Expression rewritten = potentialNullSymbolInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerSymbols)));
                if (rewritten == null) continue;
                innerPushdownConjuncts.add((Object)rewritten);
            }
            outerPushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            innerPushdownConjuncts.addAll(potentialNullSymbolInferenceWithoutInnerInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerSymbols))).getScopeEqualities());
            return new OuterJoinPushDownResult(ExpressionUtils.combineConjuncts((Iterable<Expression>)outerPushdownConjuncts.build()), ExpressionUtils.combineConjuncts((Iterable<Expression>)innerPushdownConjuncts.build()), ExpressionUtils.combineConjuncts((Iterable<Expression>)postJoinConjuncts.build()));
        }

        private InnerJoinPushDownResult processInnerJoin(Expression inheritedPredicate, Expression leftEffectivePredicate, Expression rightEffectivePredicate, Expression joinPredicate, Collection<Symbol> leftSymbols) {
            Expression rewritten;
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(leftEffectivePredicate), (com.google.common.base.Predicate)Predicates.in(leftSymbols)), (Object)"leftEffectivePredicate must only contain symbols from leftSymbols");
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(rightEffectivePredicate), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftSymbols))), (Object)"rightEffectivePredicate must not contain symbols from leftSymbols");
            ImmutableList.Builder leftPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder rightPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            joinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic)));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            joinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(joinPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic)));
            joinPredicate = ExpressionUtils.stripNonDeterministicConjuncts(joinPredicate);
            leftEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(leftEffectivePredicate);
            rightEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(rightEffectivePredicate);
            EqualityInference allInference = EqualityInference.createEqualityInference(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate);
            EqualityInference allInferenceWithoutLeftInferred = EqualityInference.createEqualityInference(inheritedPredicate, rightEffectivePredicate, joinPredicate);
            EqualityInference allInferenceWithoutRightInferred = EqualityInference.createEqualityInference(inheritedPredicate, leftEffectivePredicate, joinPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rightRewrittenConjunct;
                Expression leftRewrittenConjunct = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(leftSymbols));
                if (leftRewrittenConjunct != null) {
                    leftPushDownConjuncts.add((Object)leftRewrittenConjunct);
                }
                if ((rightRewrittenConjunct = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftSymbols)))) != null) {
                    rightPushDownConjuncts.add((Object)rightRewrittenConjunct);
                }
                if (leftRewrittenConjunct != null || rightRewrittenConjunct != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(rightEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(leftSymbols));
                if (rewritten == null) continue;
                leftPushDownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(leftEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftSymbols)));
                if (rewritten == null) continue;
                rightPushDownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(joinPredicate)) {
                Expression rightRewritten;
                Expression leftRewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(leftSymbols));
                if (leftRewritten != null) {
                    leftPushDownConjuncts.add((Object)leftRewritten);
                }
                if ((rightRewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftSymbols)))) != null) {
                    rightPushDownConjuncts.add((Object)rightRewritten);
                }
                if (leftRewritten != null || rightRewritten != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            leftPushDownConjuncts.addAll(allInferenceWithoutLeftInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(leftSymbols)).getScopeEqualities());
            rightPushDownConjuncts.addAll(allInferenceWithoutRightInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftSymbols))).getScopeEqualities());
            joinConjuncts.addAll(allInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(leftSymbols)).getScopeStraddlingEqualities());
            ImmutableList joinConjunctsList = joinConjuncts.build();
            ImmutableList postJoinConjuncts = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)joinConjunctsList, (com.google.common.base.Predicate)Predicates.not(Rewriter.joinEqualityExpression(leftSymbols))));
            joinConjunctsList = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)joinConjunctsList, Rewriter.joinEqualityExpression(leftSymbols)));
            return new InnerJoinPushDownResult(ExpressionUtils.combineConjuncts((Iterable<Expression>)leftPushDownConjuncts.build()), ExpressionUtils.combineConjuncts((Iterable<Expression>)rightPushDownConjuncts.build()), ExpressionUtils.combineConjuncts((Iterable<Expression>)joinConjunctsList), ExpressionUtils.combineConjuncts((Iterable<Expression>)postJoinConjuncts));
        }

        private static Expression extractJoinPredicate(JoinNode joinNode) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause equiJoinClause : joinNode.getCriteria()) {
                builder.add((Object)Rewriter.equalsExpression(equiJoinClause.getLeft(), equiJoinClause.getRight()));
            }
            return ExpressionUtils.combineConjuncts((Iterable<Expression>)builder.build());
        }

        private static Expression equalsExpression(Symbol symbol1, Symbol symbol2) {
            return new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new QualifiedNameReference(symbol1.toQualifiedName()), (Expression)new QualifiedNameReference(symbol2.toQualifiedName()));
        }

        private Type extractType(Expression expression) {
            return ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), expression).get(expression);
        }

        private JoinNode tryNormalizeToInnerJoin(JoinNode node, Expression inheritedPredicate) {
            Preconditions.checkArgument((boolean)EnumSet.of(JoinNode.Type.INNER, JoinNode.Type.RIGHT, JoinNode.Type.LEFT, JoinNode.Type.CROSS).contains((Object)node.getType()), (String)"Unsupported join type: %s", (Object[])new Object[]{node.getType()});
            if (node.getType() == JoinNode.Type.CROSS) {
                return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getLeftHashSymbol(), node.getRightHashSymbol());
            }
            if (node.getType() == JoinNode.Type.INNER || node.getType() == JoinNode.Type.LEFT && !this.canConvertOuterToInner(node.getRight().getOutputSymbols(), inheritedPredicate) || node.getType() == JoinNode.Type.RIGHT && !this.canConvertOuterToInner(node.getLeft().getOutputSymbols(), inheritedPredicate)) {
                return node;
            }
            return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getLeftHashSymbol(), node.getRightHashSymbol());
        }

        private boolean canConvertOuterToInner(List<Symbol> innerSymbolsForOuterJoin, Expression inheritedPredicate) {
            ImmutableSet innerSymbols = ImmutableSet.copyOf(innerSymbolsForOuterJoin);
            for (Expression conjunct : ExpressionUtils.extractConjuncts(inheritedPredicate)) {
                Object response;
                if (!DeterminismEvaluator.isDeterministic(conjunct) || (response = this.nullInputEvaluator((Collection<Symbol>)innerSymbols, conjunct)) != null && !(response instanceof NullLiteral) && !Boolean.FALSE.equals(response)) continue;
                return true;
            }
            return false;
        }

        private Expression simplifyExpression(Expression expression) {
            IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), expression);
            ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes);
            return LiteralInterpreter.toExpression(optimizer.optimize(NoOpSymbolResolver.INSTANCE), expressionTypes.get(expression));
        }

        private Object nullInputEvaluator(Collection<Symbol> nullSymbols, Expression expression) {
            IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), expression);
            return ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes).optimize(symbol -> nullSymbols.contains(symbol) ? null : new QualifiedNameReference(symbol.toQualifiedName()));
        }

        private static com.google.common.base.Predicate<Expression> joinEqualityExpression(Collection<Symbol> leftSymbols) {
            return expression -> {
                ComparisonExpression comparison;
                if (DeterminismEvaluator.isDeterministic(expression) && expression instanceof ComparisonExpression && (comparison = (ComparisonExpression)expression).getType() == ComparisonExpression.Type.EQUAL) {
                    Set<Symbol> symbols1 = DependencyExtractor.extractUnique(comparison.getLeft());
                    Set<Symbol> symbols2 = DependencyExtractor.extractUnique(comparison.getRight());
                    return Iterables.all(symbols1, (com.google.common.base.Predicate)Predicates.in((Collection)leftSymbols)) && Iterables.all(symbols2, (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in((Collection)leftSymbols))) || Iterables.all(symbols2, (com.google.common.base.Predicate)Predicates.in((Collection)leftSymbols)) && Iterables.all(symbols1, (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in((Collection)leftSymbols)));
                }
                return false;
            };
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, PlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            Expression sourceEffectivePredicate = EffectivePredicateExtractor.extract(node.getSource(), this.symbolAllocator.getTypes());
            ArrayList<Expression> sourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> filteringSourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postJoinConjuncts = new ArrayList<Expression>();
            Expression joinPredicate = Rewriter.equalsExpression(node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol());
            EqualityInference joinInference = EqualityInference.createEqualityInference(inheritedPredicate, sourceEffectivePredicate, joinPredicate);
            for (Expression conjunct : Iterables.concat(EqualityInference.nonInferrableConjuncts(inheritedPredicate), EqualityInference.nonInferrableConjuncts(sourceEffectivePredicate))) {
                Expression rewrittenConjunct = joinInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.equalTo((Object)node.getFilteringSourceJoinSymbol()));
                if (rewrittenConjunct == null || !DeterminismEvaluator.isDeterministic(rewrittenConjunct)) continue;
                Expression rewrittenConjunctOrNull = (Expression)ExpressionUtils.expressionOrNullSymbols((com.google.common.base.Predicate<Symbol>)Predicates.equalTo((Object)node.getFilteringSourceJoinSymbol())).apply((Object)rewrittenConjunct);
                filteringSourceConjuncts.add(rewrittenConjunctOrNull);
            }
            EqualityInference.EqualityPartition joinInferenceEqualityPartition = joinInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.equalTo((Object)node.getFilteringSourceJoinSymbol()));
            filteringSourceConjuncts.addAll((Collection<Expression>)ImmutableList.copyOf((Iterable)Iterables.transform(joinInferenceEqualityPartition.getScopeEqualities(), ExpressionUtils.expressionOrNullSymbols((com.google.common.base.Predicate<Symbol>)Predicates.equalTo((Object)node.getFilteringSourceJoinSymbol())))));
            EqualityInference inheritedInference = EqualityInference.createEqualityInference(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rewrittenConjunct = inheritedInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(node.getSource().getOutputSymbols()));
                if (rewrittenConjunct != null) {
                    sourceConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postJoinConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(node.getSource().getOutputSymbols()));
            sourceConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(sourceConjuncts));
            PlanNode rewrittenFilteringSource = context.rewrite(node.getFilteringSource(), ExpressionUtils.combineConjuncts(filteringSourceConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource()) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol());
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(postJoinConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, PlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            EqualityInference equalityInference = EqualityInference.createEqualityInference(inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postAggregationConjuncts = new ArrayList<Expression>();
            postAggregationConjuncts.addAll((Collection<Expression>)ImmutableList.copyOf((Iterable)Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic))));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rewrittenConjunct = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(node.getGroupBy()));
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postAggregationConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(node.getGroupBy()));
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(pushdownConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new AggregationNode(node.getId(), rewrittenSource, node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), node.getStep(), node.getSampleWeight(), node.getConfidence(), node.getHashSymbol());
            }
            if (!postAggregationConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(postAggregationConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, PlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            EqualityInference equalityInference = EqualityInference.createEqualityInference(inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postUnnestConjuncts = new ArrayList<Expression>();
            postUnnestConjuncts.addAll((Collection<Expression>)ImmutableList.copyOf((Iterable)Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic))));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rewrittenConjunct = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(node.getReplicateSymbols()));
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postUnnestConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(node.getReplicateSymbols()));
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(pushdownConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new UnnestNode(node.getId(), rewrittenSource, node.getReplicateSymbols(), node.getUnnestSymbols());
            }
            if (!postUnnestConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(postUnnestConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitSample(SampleNode node, PlanRewriter.RewriteContext<Expression> context) {
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, PlanRewriter.RewriteContext<Expression> context) {
            DomainTranslator.ExtractionResult extractionResult = DomainTranslator.fromPredicate(this.metadata, this.session, context.get(), this.symbolAllocator.getTypes(), node.getAssignments());
            Expression extractionRemainingExpression = extractionResult.getRemainingExpression();
            TupleDomain tupleDomain = extractionResult.getTupleDomain();
            if (node.getGeneratedPartitions().isPresent()) {
                tupleDomain = tupleDomain.intersect(node.getGeneratedPartitions().get().getTupleDomainInput()).intersect(node.getPartitionsDomainSummary());
            }
            PartitionResult matchingPartitions = this.splitManager.getPartitions(node.getTable(), Optional.of(tupleDomain));
            ImmutableList partitions = matchingPartitions.getPartitions();
            TupleDomain<ColumnHandle> undeterminedTupleDomain = matchingPartitions.getUndeterminedTupleDomain();
            Expression unevaluatedDomainPredicate = DomainTranslator.toPredicate(undeterminedTupleDomain, (Map<ColumnHandle, Symbol>)ImmutableBiMap.copyOf(node.getAssignments()).inverse(), this.symbolAllocator.getTypes());
            Expression postScanPredicate = ExpressionUtils.combineConjuncts(unevaluatedDomainPredicate, extractionRemainingExpression);
            partitions = ImmutableList.copyOf((Iterable)Iterables.filter(partitions, (com.google.common.base.Predicate)Predicates.not(this.shouldPrunePartition(postScanPredicate, node.getAssignments()))));
            TableScanNode.GeneratedPartitions generatedPartitions = new TableScanNode.GeneratedPartitions((TupleDomain<ColumnHandle>)tupleDomain, (List<Partition>)partitions);
            PlanNode output = node;
            if (!node.getGeneratedPartitions().equals(Optional.of(generatedPartitions))) {
                Expression originalConstraint = node.getOriginalConstraint() == null ? context.get() : node.getOriginalConstraint();
                output = new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), originalConstraint, Optional.of(generatedPartitions));
            }
            if (!postScanPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                output = new FilterNode(this.idAllocator.getNextId(), output, postScanPredicate);
            }
            return output;
        }

        private com.google.common.base.Predicate<Partition> shouldPrunePartition(Expression predicate, Map<Symbol, ColumnHandle> symbolToColumn) {
            ImmutableBiMap columnToSymbol = ImmutableBiMap.copyOf(symbolToColumn).inverse();
            List<Expression> conjuncts = ExpressionUtils.extractConjuncts(predicate);
            IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), predicate);
            return arg_0 -> this.lambda$shouldPrunePartition$92((Map)columnToSymbol, conjuncts, expressionTypes, arg_0);
        }

        private /* synthetic */ boolean lambda$shouldPrunePartition$92(Map map, List list, IdentityHashMap identityHashMap, Partition partition) {
            Map columnFixedValueAssignments = partition.getTupleDomain().extractFixedValues();
            Preconditions.checkArgument((boolean)map.keySet().containsAll(columnFixedValueAssignments.keySet()), (Object)"assignments does not contain all required column handles");
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : columnFixedValueAssignments.entrySet()) {
                Symbol translated = (Symbol)map.get(entry.getKey());
                if (translated == null) continue;
                builder.put((Object)translated, entry.getValue());
            }
            LookupSymbolResolver inputs = new LookupSymbolResolver((Map<Symbol, Object>)builder.build());
            for (Expression expression : list) {
                ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, identityHashMap);
                Object optimized = optimizer.optimize(inputs);
                if (!Boolean.FALSE.equals(optimized) && optimized != null && !(optimized instanceof NullLiteral)) continue;
                return true;
            }
            return false;
        }

        private static class InnerJoinPushDownResult {
            private final Expression leftPredicate;
            private final Expression rightPredicate;
            private final Expression joinPredicate;
            private final Expression postJoinPredicate;

            private InnerJoinPushDownResult(Expression leftPredicate, Expression rightPredicate, Expression joinPredicate, Expression postJoinPredicate) {
                this.leftPredicate = leftPredicate;
                this.rightPredicate = rightPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getLeftPredicate() {
                return this.leftPredicate;
            }

            private Expression getRightPredicate() {
                return this.rightPredicate;
            }

            private Expression getJoinPredicate() {
                return this.joinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }

        private static class OuterJoinPushDownResult {
            private final Expression outerJoinPredicate;
            private final Expression innerJoinPredicate;
            private final Expression postJoinPredicate;

            private OuterJoinPushDownResult(Expression outerJoinPredicate, Expression innerJoinPredicate, Expression postJoinPredicate) {
                this.outerJoinPredicate = outerJoinPredicate;
                this.innerJoinPredicate = innerJoinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getOuterJoinPredicate() {
                return this.outerJoinPredicate;
            }

            private Expression getInnerJoinPredicate() {
                return this.innerJoinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }
    }
}

