/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TranslationMap {
    private final RelationPlan rewriteBase;
    private final Analysis analysis;
    private final Symbol[] fieldSymbols;
    private final Map<Expression, Symbol> expressionMappings = new HashMap<Expression, Symbol>();

    public TranslationMap(RelationPlan rewriteBase, Analysis analysis) {
        this.rewriteBase = rewriteBase;
        this.analysis = analysis;
        this.fieldSymbols = new Symbol[rewriteBase.getOutputSymbols().size()];
    }

    public RelationPlan getRelationPlan() {
        return this.rewriteBase;
    }

    public void setFieldMappings(List<Symbol> symbols) {
        Preconditions.checkArgument((symbols.size() == this.fieldSymbols.length ? 1 : 0) != 0, (String)"size of symbols list (%s) doesn't match number of expected fields (%s)", (Object[])new Object[]{symbols.size(), this.fieldSymbols.length});
        for (int i = 0; i < symbols.size(); ++i) {
            this.fieldSymbols[i] = symbols.get(i);
        }
    }

    public void copyMappingsFrom(TranslationMap other) {
        Preconditions.checkArgument((other.fieldSymbols.length == this.fieldSymbols.length ? 1 : 0) != 0, (String)"number of fields in other (%s) doesn't match number of expected fields (%s)", (Object[])new Object[]{other.fieldSymbols.length, this.fieldSymbols.length});
        this.expressionMappings.putAll(other.expressionMappings);
        System.arraycopy(other.fieldSymbols, 0, this.fieldSymbols, 0, other.fieldSymbols.length);
    }

    public Expression rewrite(Expression expression) {
        Expression mapped = this.translateNamesToSymbols(expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Symbol symbol = (Symbol)TranslationMap.this.expressionMappings.get(node);
                Object rewrittenExpression = symbol != null ? new QualifiedNameReference(symbol.toQualifiedName()) : treeRewriter.defaultRewrite(node, (Object)context);
                return rewrittenExpression;
            }
        }, (Expression)mapped);
    }

    public Expression rewrite(FieldOrExpression fieldOrExpression) {
        if (fieldOrExpression.isFieldReference()) {
            int fieldIndex = fieldOrExpression.getFieldIndex();
            Symbol symbol = this.fieldSymbols[fieldIndex];
            Preconditions.checkState((symbol != null ? 1 : 0) != 0, (String)"No mapping for field '%s'", (Object[])new Object[]{fieldIndex});
            return new QualifiedNameReference(symbol.toQualifiedName());
        }
        return this.rewrite(fieldOrExpression.getExpression());
    }

    public void put(Expression expression, Symbol symbol) {
        Expression translated = this.translateNamesToSymbols(expression);
        this.expressionMappings.put(translated, symbol);
        if (expression instanceof QualifiedNameReference) {
            int fieldIndex = this.analysis.getResolvedNames(expression).get(((QualifiedNameReference)expression).getName());
            this.fieldSymbols[fieldIndex] = symbol;
        }
    }

    public void put(FieldOrExpression fieldOrExpression, Symbol symbol) {
        if (fieldOrExpression.isFieldReference()) {
            int fieldIndex = fieldOrExpression.getFieldIndex();
            this.fieldSymbols[fieldIndex] = symbol;
            this.expressionMappings.put((Expression)new QualifiedNameReference(this.rewriteBase.getSymbol(fieldIndex).toQualifiedName()), symbol);
        } else {
            this.put(fieldOrExpression.getExpression(), symbol);
        }
    }

    public Symbol get(Expression expression) {
        Expression translated = this.translateNamesToSymbols(expression);
        Preconditions.checkArgument((boolean)this.expressionMappings.containsKey(translated), (String)"No mapping for expression: %s", (Object[])new Object[]{expression});
        return this.expressionMappings.get(translated);
    }

    public Symbol get(FieldOrExpression fieldOrExpression) {
        if (fieldOrExpression.isFieldReference()) {
            int field = fieldOrExpression.getFieldIndex();
            Preconditions.checkArgument((this.fieldSymbols[field] != null ? 1 : 0) != 0, (String)"No mapping for field: %s", (Object[])new Object[]{field});
            return this.fieldSymbols[field];
        }
        return this.get(fieldOrExpression.getExpression());
    }

    private Expression translateNamesToSymbols(Expression expression) {
        final Map<QualifiedName, Integer> resolvedNames = this.analysis.getResolvedNames(expression);
        Preconditions.checkArgument((resolvedNames != null ? 1 : 0) != 0, (String)"No resolved names for expression %s", (Object[])new Object[]{expression});
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                Type coercion = TranslationMap.this.analysis.getCoercion(node);
                if (coercion != null) {
                    rewrittenExpression = new Cast(rewrittenExpression, coercion.getTypeSignature().toString());
                }
                return rewrittenExpression;
            }

            public Expression rewriteQualifiedNameReference(QualifiedNameReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Type coercion;
                QualifiedName name = node.getName();
                Integer fieldIndex = (Integer)resolvedNames.get(name);
                Preconditions.checkState((fieldIndex != null ? 1 : 0) != 0, (String)"No field mapping for name '%s'", (Object[])new Object[]{name});
                Symbol symbol = TranslationMap.this.rewriteBase.getSymbol(fieldIndex);
                Preconditions.checkState((symbol != null ? 1 : 0) != 0, (String)"No symbol mapping for name '%s' (%s)", (Object[])new Object[]{name, fieldIndex});
                QualifiedNameReference rewrittenExpression = new QualifiedNameReference(symbol.toQualifiedName());
                if (TranslationMap.this.analysis.isRowFieldAccessor(node)) {
                    QualifiedName mangledName = QualifiedName.of((String)FunctionRegistry.mangleFieldAccessor(node.getName().getSuffix()), (String[])new String[0]);
                    rewrittenExpression = new FunctionCall(mangledName, (List)ImmutableList.of((Object)rewrittenExpression));
                }
                if ((coercion = TranslationMap.this.analysis.getCoercion((Expression)node)) != null) {
                    rewrittenExpression = new Cast((Expression)rewrittenExpression, coercion.getTypeSignature().toString());
                }
                return rewrittenExpression;
            }
        }, (Expression)expression);
    }
}

