/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class StageExecutionPlan {
    private final PlanFragment fragment;
    private final Optional<SplitSource> dataSource;
    private final List<StageExecutionPlan> subStages;
    private final Optional<List<String>> fieldNames;

    public StageExecutionPlan(PlanFragment fragment, Optional<SplitSource> dataSource, List<StageExecutionPlan> subStages) {
        this.fragment = (PlanFragment)Preconditions.checkNotNull((Object)fragment, (Object)"fragment is null");
        this.dataSource = (Optional)Preconditions.checkNotNull(dataSource, (Object)"dataSource is null");
        this.subStages = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(subStages, (Object)"dependencies is null")));
        this.fieldNames = fragment.getRoot() instanceof OutputNode ? Optional.of(ImmutableList.copyOf(((OutputNode)fragment.getRoot()).getColumnNames())) : Optional.empty();
    }

    public List<String> getFieldNames() {
        Preconditions.checkState((boolean)this.fieldNames.isPresent(), (Object)"cannot get field names from non-output stage");
        return this.fieldNames.get();
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public Optional<SplitSource> getDataSource() {
        return this.dataSource;
    }

    public List<StageExecutionPlan> getSubStages() {
        return this.subStages;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fragment", (Object)this.fragment).add("dataSource", this.dataSource).add("subStages", this.subStages).toString();
    }
}

