/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolExtractor;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PlanFragmenter {
    public SubPlan createSubPlans(Plan plan) {
        Fragmenter fragmenter = new Fragmenter(plan.getSymbolAllocator().getTypes());
        FragmentProperties properties = new FragmentProperties();
        PlanNode root = PlanRewriter.rewriteWith(fragmenter, plan.getRoot(), properties);
        SubPlan result = fragmenter.buildFragment(root, properties);
        result.sanityCheck();
        return result;
    }

    private static class FragmentProperties {
        private final List<SubPlan> children = new ArrayList<SubPlan>();
        private Optional<List<Symbol>> outputLayout = Optional.empty();
        private Optional<PlanFragment.OutputPartitioning> outputPartitioning = Optional.empty();
        private List<Symbol> partitionBy = ImmutableList.of();
        private Optional<Symbol> hash = Optional.empty();
        private Optional<PlanFragment.PlanDistribution> distribution = Optional.empty();
        private PlanNodeId distributeBy;

        private FragmentProperties() {
        }

        public List<SubPlan> getChildren() {
            return this.children;
        }

        public FragmentProperties setSingleNodeDistribution() {
            if (this.distribution.isPresent()) {
                PlanFragment.PlanDistribution value = this.distribution.get();
                Preconditions.checkState((value == PlanFragment.PlanDistribution.SINGLE || value == PlanFragment.PlanDistribution.COORDINATOR_ONLY ? 1 : 0) != 0, (String)"Cannot overwrite distribution with %s (currently set to %s)", (Object[])new Object[]{PlanFragment.PlanDistribution.SINGLE, value});
            } else {
                this.distribution = Optional.of(PlanFragment.PlanDistribution.SINGLE);
            }
            return this;
        }

        public FragmentProperties setFixedDistribution() {
            this.distribution.ifPresent(current -> Preconditions.checkState((current == PlanFragment.PlanDistribution.FIXED ? 1 : 0) != 0, (String)"Cannot set distribution to %s. Already set to %s", (Object[])new Object[]{PlanFragment.PlanDistribution.FIXED, current}));
            this.distribution = Optional.of(PlanFragment.PlanDistribution.FIXED);
            return this;
        }

        public FragmentProperties setCoordinatorOnlyDistribution() {
            this.distribution.ifPresent(current -> Preconditions.checkState((this.distribution.get() == PlanFragment.PlanDistribution.SINGLE ? 1 : 0) != 0, (String)"Cannot overwrite distribution with %s (currently set to %s)", (Object[])new Object[]{PlanFragment.PlanDistribution.COORDINATOR_ONLY, this.distribution.get()}));
            this.distribution = Optional.of(PlanFragment.PlanDistribution.COORDINATOR_ONLY);
            return this;
        }

        public FragmentProperties setSourceDistribution(PlanNodeId source) {
            if (this.distribution.isPresent()) {
                Preconditions.checkState((this.distribution.get() == PlanFragment.PlanDistribution.SINGLE || this.distribution.get() == PlanFragment.PlanDistribution.COORDINATOR_ONLY ? 1 : 0) != 0, (String)"Cannot overwrite distribution with %s (currently set to %s)", (Object[])new Object[]{PlanFragment.PlanDistribution.SOURCE, this.distribution.get()});
            } else {
                this.distribution = Optional.of(PlanFragment.PlanDistribution.SOURCE);
                this.distributeBy = source;
            }
            return this;
        }

        public FragmentProperties setUnpartitionedOutput() {
            this.outputPartitioning.ifPresent(current -> {
                throw new IllegalStateException(String.format("Output overwrite partitioning with %s (currently set to %s)", new Object[]{PlanFragment.OutputPartitioning.NONE, current}));
            });
            this.outputPartitioning = Optional.of(PlanFragment.OutputPartitioning.NONE);
            return this;
        }

        public FragmentProperties setOutputLayout(List<Symbol> layout) {
            this.outputLayout.ifPresent(current -> {
                throw new IllegalStateException(String.format("Cannot overwrite output layout with %s (currently set to %s)", layout, current));
            });
            this.outputLayout = Optional.of(layout);
            return this;
        }

        public FragmentProperties setHashPartitionedOutput(List<Symbol> partitionKeys, Optional<Symbol> hash) {
            this.outputPartitioning.ifPresent(current -> {
                throw new IllegalStateException(String.format("Cannot overwrite output partitioning with %s (currently set to %s)", new Object[]{PlanFragment.OutputPartitioning.HASH, current}));
            });
            this.outputPartitioning = Optional.of(PlanFragment.OutputPartitioning.HASH);
            this.partitionBy = ImmutableList.copyOf(partitionKeys);
            this.hash = hash;
            return this;
        }

        public FragmentProperties addChildren(List<SubPlan> children) {
            this.children.addAll(children);
            return this;
        }

        public List<Symbol> getOutputLayout() {
            return this.outputLayout.get();
        }

        public PlanFragment.OutputPartitioning getOutputPartitioning() {
            return this.outputPartitioning.get();
        }

        public PlanFragment.PlanDistribution getDistribution() {
            return this.distribution.get();
        }

        public List<Symbol> getPartitionBy() {
            return this.partitionBy;
        }

        public Optional<Symbol> getHash() {
            return this.hash;
        }

        public PlanNodeId getDistributeBy() {
            return this.distributeBy;
        }
    }

    private static class Fragmenter
    extends PlanRewriter<FragmentProperties> {
        private final Map<Symbol, Type> types;
        private int nextFragmentId;

        public Fragmenter(Map<Symbol, Type> types) {
            this.types = types;
        }

        private PlanFragmentId nextFragmentId() {
            return new PlanFragmentId(String.valueOf(this.nextFragmentId++));
        }

        private SubPlan buildFragment(PlanNode root, FragmentProperties properties) {
            Set<Symbol> dependencies = SymbolExtractor.extract(root);
            PlanFragment fragment = new PlanFragment(this.nextFragmentId(), root, Maps.filterKeys(this.types, (Predicate)Predicates.in(dependencies)), properties.getOutputLayout(), properties.getDistribution(), properties.getDistributeBy(), properties.getOutputPartitioning(), properties.getPartitionBy(), properties.getHash());
            return new SubPlan(fragment, properties.getChildren());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, PlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution().setOutputLayout(node.getOutputSymbols()).setUnpartitionedOutput();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableCommit(TableCommitNode node, PlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, PlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSourceDistribution(node.getId());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitValues(ValuesNode node, PlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExchange(ExchangeNode exchange, PlanRewriter.RewriteContext<FragmentProperties> context) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (exchange.getType() == ExchangeNode.Type.GATHER) {
                context.get().setSingleNodeDistribution();
                for (int i = 0; i < exchange.getSources().size(); ++i) {
                    FragmentProperties childProperties = new FragmentProperties();
                    childProperties.setUnpartitionedOutput();
                    childProperties.setOutputLayout(exchange.getInputs().get(i));
                    builder.add((Object)this.buildSubPlan(exchange.getSources().get(i), childProperties, context));
                }
            } else if (exchange.getType() == ExchangeNode.Type.REPARTITION) {
                context.get().setFixedDistribution();
                FragmentProperties childProperties = new FragmentProperties().setHashPartitionedOutput(exchange.getPartitionKeys(), exchange.getHashSymbol()).setOutputLayout((List)Iterables.getOnlyElement(exchange.getInputs()));
                builder.add((Object)this.buildSubPlan((PlanNode)Iterables.getOnlyElement(exchange.getSources()), childProperties, context));
            } else if (exchange.getType() == ExchangeNode.Type.REPLICATE) {
                FragmentProperties childProperties = new FragmentProperties();
                childProperties.setUnpartitionedOutput();
                childProperties.setOutputLayout((List)Iterables.getOnlyElement(exchange.getInputs()));
                builder.add((Object)this.buildSubPlan((PlanNode)Iterables.getOnlyElement(exchange.getSources()), childProperties, context));
            }
            ImmutableList children = builder.build();
            context.get().addChildren((List<SubPlan>)children);
            List childrenIds = (List)children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableCollectors.toImmutableList());
            return new RemoteSourceNode(exchange.getId(), childrenIds, exchange.getOutputSymbols());
        }

        private SubPlan buildSubPlan(PlanNode node, FragmentProperties properties, PlanRewriter.RewriteContext<FragmentProperties> context) {
            PlanNode child = context.rewrite(node, properties);
            return this.buildFragment(child, properties);
        }
    }
}

