/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PlanFragment {
    private final PlanFragmentId id;
    private final PlanNode root;
    private final Map<Symbol, Type> symbols;
    private final List<Symbol> outputLayout;
    private final PlanDistribution distribution;
    private final PlanNodeId partitionedSource;
    private final List<Type> types;
    private final List<PlanNode> sources;
    private final Set<PlanNodeId> sourceIds;
    private final OutputPartitioning outputPartitioning;
    private final List<Symbol> partitionBy;
    private final Optional<Symbol> hash;

    @JsonCreator
    public PlanFragment(@JsonProperty(value="id") PlanFragmentId id, @JsonProperty(value="root") PlanNode root, @JsonProperty(value="symbols") Map<Symbol, Type> symbols, @JsonProperty(value="outputLayout") List<Symbol> outputLayout, @JsonProperty(value="distribution") PlanDistribution distribution, @JsonProperty(value="partitionedSource") PlanNodeId partitionedSource, @JsonProperty(value="outputPartitioning") OutputPartitioning outputPartitioning, @JsonProperty(value="partitionBy") List<Symbol> partitionBy, @JsonProperty(value="hash") Optional<Symbol> hash) {
        this.id = (PlanFragmentId)Preconditions.checkNotNull((Object)id, (Object)"id is null");
        this.root = (PlanNode)Preconditions.checkNotNull((Object)root, (Object)"root is null");
        this.symbols = (Map)Preconditions.checkNotNull(symbols, (Object)"symbols is null");
        this.outputLayout = (List)Preconditions.checkNotNull(outputLayout, (Object)"outputLayout is null");
        this.distribution = (PlanDistribution)((Object)Preconditions.checkNotNull((Object)((Object)distribution), (Object)"distribution is null"));
        this.partitionedSource = partitionedSource;
        this.partitionBy = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionBy, (Object)"partitionBy is null")));
        this.hash = hash;
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(root.getOutputSymbols()).containsAll(outputLayout), (String)"Root node outputs (%s) don't include all fragment outputs (%s)", (Object[])new Object[]{root.getOutputSymbols(), outputLayout});
        this.types = (List)root.getOutputSymbols().stream().map(symbols::get).collect(ImmutableCollectors.toImmutableList());
        ImmutableList.Builder sources = ImmutableList.builder();
        PlanFragment.findSources(root, (ImmutableList.Builder<PlanNode>)sources, partitionedSource);
        this.sources = sources.build();
        ImmutableSet.Builder sourceIds = ImmutableSet.builder();
        for (PlanNode source : this.sources) {
            sourceIds.add((Object)source.getId());
        }
        if (partitionedSource != null) {
            sourceIds.add((Object)partitionedSource);
        }
        this.sourceIds = sourceIds.build();
        this.outputPartitioning = (OutputPartitioning)((Object)Preconditions.checkNotNull((Object)((Object)outputPartitioning), (Object)"outputPartitioning is null"));
    }

    @JsonProperty
    public PlanFragmentId getId() {
        return this.id;
    }

    @JsonProperty
    public PlanNode getRoot() {
        return this.root;
    }

    @JsonProperty
    public Map<Symbol, Type> getSymbols() {
        return this.symbols;
    }

    @JsonProperty
    public List<Symbol> getOutputLayout() {
        return this.outputLayout;
    }

    @JsonProperty
    public PlanDistribution getDistribution() {
        return this.distribution;
    }

    @JsonProperty
    public PlanNodeId getPartitionedSource() {
        return this.partitionedSource;
    }

    @JsonProperty
    public OutputPartitioning getOutputPartitioning() {
        return this.outputPartitioning;
    }

    @JsonProperty
    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public Optional<Symbol> getHash() {
        return this.hash;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public List<PlanNode> getSources() {
        return this.sources;
    }

    public Set<PlanNodeId> getSourceIds() {
        return this.sourceIds;
    }

    private static void findSources(PlanNode node, ImmutableList.Builder<PlanNode> builder, PlanNodeId partitionedSource) {
        for (PlanNode source : node.getSources()) {
            PlanFragment.findSources(source, builder, partitionedSource);
        }
        if (node.getSources().isEmpty() && !(node instanceof IndexSourceNode) || node.getId().equals(partitionedSource)) {
            builder.add((Object)node);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("distribution", (Object)this.distribution).add("partitionedSource", (Object)this.partitionedSource).add("outputPartitioning", (Object)this.outputPartitioning).add("hash", this.hash).toString();
    }

    public static enum OutputPartitioning {
        NONE,
        HASH;

    }

    public static enum PlanDistribution {
        SINGLE,
        FIXED,
        SOURCE,
        COORDINATOR_ONLY;

    }
}

