/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Partition;
import com.facebook.presto.metadata.PartitionResult;
import com.facebook.presto.split.SampledSplitSource;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.StageExecutionPlan;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public class DistributedExecutionPlanner {
    private final SplitManager splitManager;

    @Inject
    public DistributedExecutionPlanner(SplitManager splitManager) {
        this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
    }

    public StageExecutionPlan plan(SubPlan root) {
        PlanFragment currentFragment = root.getFragment();
        Visitor visitor = new Visitor();
        Optional<SplitSource> splits = currentFragment.getRoot().accept(visitor, null);
        ImmutableList.Builder dependencies = ImmutableList.builder();
        for (SubPlan childPlan : root.getChildren()) {
            dependencies.add((Object)this.plan(childPlan));
        }
        return new StageExecutionPlan(currentFragment, splits, (List<StageExecutionPlan>)dependencies.build());
    }

    private final class Visitor
    extends PlanVisitor<Void, Optional<SplitSource>> {
        private Visitor() {
        }

        @Override
        public Optional<SplitSource> visitTableScan(TableScanNode node, Void context) {
            SplitSource splitSource = DistributedExecutionPlanner.this.splitManager.getPartitionSplits(node.getTable(), this.getPartitions(node));
            return Optional.of(splitSource);
        }

        private List<Partition> getPartitions(TableScanNode node) {
            if (node.getGeneratedPartitions().isPresent()) {
                return node.getGeneratedPartitions().get().getPartitions();
            }
            PartitionResult allPartitions = DistributedExecutionPlanner.this.splitManager.getPartitions(node.getTable(), Optional.empty());
            return allPartitions.getPartitions();
        }

        @Override
        public Optional<SplitSource> visitJoin(JoinNode node, Void context) {
            Optional<SplitSource> leftSplits = node.getLeft().accept(this, context);
            Optional<SplitSource> rightSplits = node.getRight().accept(this, context);
            if (leftSplits.isPresent() && rightSplits.isPresent()) {
                throw new IllegalArgumentException("Both left and right join nodes are partitioned");
            }
            return leftSplits.isPresent() ? leftSplits : rightSplits;
        }

        @Override
        public Optional<SplitSource> visitSemiJoin(SemiJoinNode node, Void context) {
            Optional<SplitSource> sourceSplits = node.getSource().accept(this, context);
            Optional<SplitSource> filteringSourceSplits = node.getFilteringSource().accept(this, context);
            if (sourceSplits.isPresent() && filteringSourceSplits.isPresent()) {
                throw new IllegalArgumentException("Both source and filteringSource semi join nodes are partitioned");
            }
            return sourceSplits.isPresent() ? sourceSplits : filteringSourceSplits;
        }

        @Override
        public Optional<SplitSource> visitIndexJoin(IndexJoinNode node, Void context) {
            return node.getProbeSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitRemoteSource(RemoteSourceNode node, Void context) {
            return Optional.empty();
        }

        @Override
        public Optional<SplitSource> visitValues(ValuesNode node, Void context) {
            return Optional.empty();
        }

        @Override
        public Optional<SplitSource> visitFilter(FilterNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitSample(SampleNode node, Void context) {
            switch (node.getSampleType()) {
                case BERNOULLI: 
                case POISSONIZED: {
                    return node.getSource().accept(this, context);
                }
                case SYSTEM: {
                    Optional<SplitSource> nodeSplits = node.getSource().accept(this, context);
                    if (nodeSplits.isPresent()) {
                        SampledSplitSource sampledSplitSource = new SampledSplitSource(nodeSplits.get(), node.getSampleRatio());
                        return Optional.of(sampledSplitSource);
                    }
                    return nodeSplits;
                }
            }
            throw new UnsupportedOperationException("Sampling is not supported for type " + (Object)((Object)node.getSampleType()));
        }

        @Override
        public Optional<SplitSource> visitAggregation(AggregationNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitMarkDistinct(MarkDistinctNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitWindow(WindowNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitRowNumber(RowNumberNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitProject(ProjectNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitUnnest(UnnestNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitTopN(TopNNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitOutput(OutputNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitLimit(LimitNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitDistinctLimit(DistinctLimitNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitSort(SortNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitTableWriter(TableWriterNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitTableCommit(TableCommitNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Optional<SplitSource> visitUnion(UnionNode node, Void context) {
            Optional<SplitSource> result = Optional.empty();
            for (PlanNode child : node.getSources()) {
                Optional<SplitSource> source = child.accept(this, context);
                if (result.isPresent() && source.isPresent()) {
                    throw new IllegalArgumentException("Multiple children are source-distributed");
                }
                if (!source.isPresent()) continue;
                result = source;
            }
            return result;
        }

        @Override
        protected Optional<SplitSource> visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }
    }
}

