/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.operator.InMemoryJoinHash;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.IsolatedClass;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class JoinCompiler {
    private final LoadingCache<CacheKey, LookupSourceFactory> lookupSourceFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<CacheKey, LookupSourceFactory>(){

        public LookupSourceFactory load(CacheKey key) throws Exception {
            return JoinCompiler.this.internalCompileLookupSourceFactory(key.getTypes(), key.getJoinChannels());
        }
    });
    private final LoadingCache<CacheKey, Class<? extends PagesHashStrategy>> hashStrategies = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<CacheKey, Class<? extends PagesHashStrategy>>(){

        public Class<? extends PagesHashStrategy> load(CacheKey key) throws Exception {
            return JoinCompiler.this.internalCompileHashStrategy(key.getTypes(), key.getJoinChannels());
        }
    });

    public LookupSourceFactory compileLookupSourceFactory(List<? extends Type> types, List<Integer> joinChannels) {
        try {
            return (LookupSourceFactory)this.lookupSourceFactories.get((Object)new CacheKey(types, joinChannels));
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public PagesHashStrategyFactory compilePagesHashStrategyFactory(List<Type> types, List<Integer> joinChannels) {
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull(joinChannels, (Object)"joinChannels is null");
        try {
            return new PagesHashStrategyFactory((Class)this.hashStrategies.get((Object)new CacheKey(types, joinChannels)));
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private LookupSourceFactory internalCompileLookupSourceFactory(List<Type> types, List<Integer> joinChannels) {
        Class<? extends PagesHashStrategy> pagesHashStrategyClass = this.internalCompileHashStrategy(types, joinChannels);
        Class<InMemoryJoinHash> lookupSourceClass = IsolatedClass.isolateClass(new DynamicClassLoader(this.getClass().getClassLoader()), LookupSource.class, InMemoryJoinHash.class, new Class[0]);
        return new LookupSourceFactory(lookupSourceClass, new PagesHashStrategyFactory(pagesHashStrategyClass));
    }

    private Class<? extends PagesHashStrategy> internalCompileHashStrategy(List<Type> types, List<Integer> joinChannels) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("PagesHashStrategy"), ParameterizedType.type(Object.class), ParameterizedType.type(PagesHashStrategy.class));
        ArrayList<FieldDefinition> channelFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < types.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "channel_" + i, ParameterizedType.type(List.class, Block.class));
            channelFields.add(channelField);
        }
        ArrayList<Type> joinChannelTypes = new ArrayList<Type>();
        ArrayList<FieldDefinition> joinChannelFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < joinChannels.size(); ++i) {
            joinChannelTypes.add(types.get(joinChannels.get(i)));
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "joinChannel_" + i, ParameterizedType.type(List.class, Block.class));
            joinChannelFields.add(channelField);
        }
        FieldDefinition hashChannelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "hashChannel", ParameterizedType.type(List.class, Block.class));
        this.generateConstructor(classDefinition, joinChannels, channelFields, joinChannelFields, hashChannelField);
        this.generateGetChannelCountMethod(classDefinition, channelFields);
        this.generateAppendToMethod(classDefinition, callSiteBinder, types, channelFields);
        this.generateHashPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, hashChannelField);
        this.generateHashRowMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        this.generatePositionEqualsRowMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        this.generatePositionEqualsPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        return CompilerUtils.defineClass(classDefinition, PagesHashStrategy.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private void generateConstructor(ClassDefinition classDefinition, List<Integer> joinChannels, List<FieldDefinition> channelFields, List<FieldDefinition> joinChannelFields, FieldDefinition hashChannelField) {
        int index;
        CompilerContext compilerContext = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        com.facebook.presto.byteCode.Block constructor = classDefinition.declareConstructor(compilerContext, Access.a(Access.PUBLIC), NamedParameterDefinition.arg("channels", ParameterizedType.type(List.class, ParameterizedType.type(List.class, Block.class))), NamedParameterDefinition.arg("hashChannel", ParameterizedType.type(Optional.class, Integer.class))).getBody().comment("super();").pushThis().invokeConstructor(Object.class, new Class[0]);
        constructor.comment("Set channel fields");
        for (index = 0; index < channelFields.size(); ++index) {
            ByteCodeExpression channel = compilerContext.getVariable("channels").invoke("get", Object.class, ByteCodeExpressions.constantInt(index)).cast(ParameterizedType.type(List.class, Block.class));
            constructor.append(compilerContext.getVariable("this").setField(channelFields.get(index), channel));
        }
        constructor.comment("Set join channel fields");
        for (index = 0; index < joinChannelFields.size(); ++index) {
            ByteCodeExpression joinChannel = compilerContext.getVariable("channels").invoke("get", Object.class, ByteCodeExpressions.constantInt(joinChannels.get(index))).cast(ParameterizedType.type(List.class, Block.class));
            constructor.append(compilerContext.getVariable("this").setField(joinChannelFields.get(index), joinChannel));
        }
        constructor.comment("Set hashChannel");
        Variable hashChannel = compilerContext.getVariable("hashChannel");
        constructor.append(new IfStatement(compilerContext, hashChannel.invoke("isPresent", Boolean.TYPE, new ByteCodeExpression[0]), compilerContext.getVariable("this").setField(hashChannelField, compilerContext.getVariable("channels").invoke("get", Object.class, hashChannel.invoke("get", Object.class, new ByteCodeExpression[0]).cast(Integer.class).cast(Integer.TYPE))), compilerContext.getVariable("this").setField(hashChannelField, ByteCodeExpressions.constantNull(hashChannelField.getType()))));
        constructor.ret();
    }

    private void generateGetChannelCountMethod(ClassDefinition classDefinition, List<FieldDefinition> channelFields) {
        classDefinition.declareMethod(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), Access.a(Access.PUBLIC), "getChannelCount", ParameterizedType.type(Integer.TYPE), new NamedParameterDefinition[0]).getBody().push(channelFields.size()).retInt();
    }

    private void generateAppendToMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<FieldDefinition> channelFields) {
        CompilerContext compilerContext = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        com.facebook.presto.byteCode.Block appendToBody = classDefinition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "appendTo", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("blockIndex", Integer.TYPE), NamedParameterDefinition.arg("blockPosition", Integer.TYPE), NamedParameterDefinition.arg("pageBuilder", PageBuilder.class), NamedParameterDefinition.arg("outputChannelOffset", Integer.TYPE)).getBody();
        for (int index = 0; index < channelFields.size(); ++index) {
            Type type = types.get(index);
            ByteCodeExpression typeExpression = SqlTypeByteCodeExpression.constantType(compilerContext, callSiteBinder, type);
            ByteCodeExpression block = compilerContext.getVariable("this").getField(channelFields.get(index)).invoke("get", Object.class, compilerContext.getVariable("blockIndex")).cast(Block.class);
            appendToBody.comment("%s.appendTo(channel_%s.get(blockIndex), blockPosition, pageBuilder.getBlockBuilder(outputChannelOffset + %s));", type.getClass(), index, index).append(typeExpression).append(block).getVariable("blockPosition").getVariable("pageBuilder").getVariable("outputChannelOffset").push(index).append(OpCode.IADD).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE).invokeInterface(Type.class, "appendTo", Void.TYPE, Block.class, Integer.TYPE, BlockBuilder.class);
        }
        appendToBody.ret();
    }

    private void generateHashPositionMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields, FieldDefinition hashChannelField) {
        CompilerContext compilerContext = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition hashPositionMethod = classDefinition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "hashPosition", ParameterizedType.type(Integer.TYPE), NamedParameterDefinition.arg("blockIndex", Integer.TYPE), NamedParameterDefinition.arg("blockPosition", Integer.TYPE));
        Variable thisVariable = compilerContext.getVariable("this");
        ByteCodeExpression hashChannel = thisVariable.getField(hashChannelField);
        ByteCodeExpression bigintType = SqlTypeByteCodeExpression.constantType(compilerContext, callSiteBinder, (Type)BigintType.BIGINT);
        Variable blockIndex = compilerContext.getVariable("blockIndex");
        Variable blockPosition = compilerContext.getVariable("blockPosition");
        IfStatement.IfStatementBuilder ifStatementBuilder = new IfStatement.IfStatementBuilder(compilerContext);
        ifStatementBuilder.condition(ByteCodeExpressions.notEqual(hashChannel, ByteCodeExpressions.constantNull(hashChannelField.getType())));
        ifStatementBuilder.ifTrue(bigintType.invoke("getLong", Long.TYPE, hashChannel.invoke("get", Object.class, blockIndex).cast(Block.class), blockPosition).cast(Integer.TYPE).ret());
        hashPositionMethod.getBody().append(ifStatementBuilder.build());
        Variable resultVariable = hashPositionMethod.getCompilerContext().declareVariable(Integer.TYPE, "result");
        hashPositionMethod.getBody().push(0).putVariable(resultVariable);
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            ByteCodeExpression type = SqlTypeByteCodeExpression.constantType(compilerContext, callSiteBinder, joinChannelTypes.get(index));
            ByteCodeExpression block = compilerContext.getVariable("this").getField(joinChannelFields.get(index)).invoke("get", Object.class, compilerContext.getVariable("blockIndex")).cast(Block.class);
            hashPositionMethod.getBody().getVariable(resultVariable).push(31).append(OpCode.IMUL).append(JoinCompiler.typeHashCode(compilerContext, type, block, compilerContext.getVariable("blockPosition"))).append(OpCode.IADD).putVariable(resultVariable);
        }
        hashPositionMethod.getBody().getVariable(resultVariable).retInt();
    }

    private void generateHashRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        CompilerContext compilerContext = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition hashPositionMethod = classDefinition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "hashRow", ParameterizedType.type(Integer.TYPE), NamedParameterDefinition.arg("position", Integer.TYPE), NamedParameterDefinition.arg("blocks", Block[].class));
        Variable resultVariable = hashPositionMethod.getCompilerContext().declareVariable(Integer.TYPE, "result");
        hashPositionMethod.getBody().push(0).putVariable(resultVariable);
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            ByteCodeExpression type = SqlTypeByteCodeExpression.constantType(compilerContext, callSiteBinder, joinChannelTypes.get(index));
            ByteCodeExpression block = compilerContext.getVariable("blocks").getElement(index).cast(Block.class);
            hashPositionMethod.getBody().getVariable(resultVariable).push(31).append(OpCode.IMUL).append(JoinCompiler.typeHashCode(compilerContext, type, block, compilerContext.getVariable("position"))).append(OpCode.IADD).putVariable(resultVariable);
        }
        hashPositionMethod.getBody().getVariable(resultVariable).retInt();
    }

    private static ByteCodeNode typeHashCode(CompilerContext compilerContext, ByteCodeExpression type, ByteCodeExpression blockRef, ByteCodeExpression blockPosition) {
        IfStatement.IfStatementBuilder ifStatementBuilder = new IfStatement.IfStatementBuilder(compilerContext);
        ifStatementBuilder.condition(new com.facebook.presto.byteCode.Block(compilerContext).append(blockRef.invoke("isNull", Boolean.TYPE, blockPosition)));
        ifStatementBuilder.ifTrue(new com.facebook.presto.byteCode.Block(compilerContext).push(0));
        ifStatementBuilder.ifFalse(new com.facebook.presto.byteCode.Block(compilerContext).append(type.invoke("hash", Integer.TYPE, blockRef, blockPosition)));
        return ifStatementBuilder.build();
    }

    private void generatePositionEqualsRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        CompilerContext compilerContext = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition hashPositionMethod = classDefinition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "positionEqualsRow", ParameterizedType.type(Boolean.TYPE), NamedParameterDefinition.arg("leftBlockIndex", Integer.TYPE), NamedParameterDefinition.arg("leftBlockPosition", Integer.TYPE), NamedParameterDefinition.arg("rightPosition", Integer.TYPE), NamedParameterDefinition.arg("rightBlocks", Block[].class));
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            ByteCodeExpression type = SqlTypeByteCodeExpression.constantType(compilerContext, callSiteBinder, joinChannelTypes.get(index));
            ByteCodeExpression leftBlock = compilerContext.getVariable("this").getField(joinChannelFields.get(index)).invoke("get", Object.class, compilerContext.getVariable("leftBlockIndex")).cast(Block.class);
            ByteCodeExpression rightBlock = compilerContext.getVariable("rightBlocks").getElement(index);
            LabelNode checkNextField = new LabelNode("checkNextField");
            hashPositionMethod.getBody().append(JoinCompiler.typeEquals(compilerContext, type, leftBlock, compilerContext.getVariable("leftBlockPosition"), rightBlock, compilerContext.getVariable("rightPosition"))).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        hashPositionMethod.getBody().push(true).retInt();
    }

    private void generatePositionEqualsPositionMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        CompilerContext compilerContext = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition hashPositionMethod = classDefinition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "positionEqualsPosition", ParameterizedType.type(Boolean.TYPE), NamedParameterDefinition.arg("leftBlockIndex", Integer.TYPE), NamedParameterDefinition.arg("leftBlockPosition", Integer.TYPE), NamedParameterDefinition.arg("rightBlockIndex", Integer.TYPE), NamedParameterDefinition.arg("rightBlockPosition", Integer.TYPE));
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            ByteCodeExpression type = SqlTypeByteCodeExpression.constantType(compilerContext, callSiteBinder, joinChannelTypes.get(index));
            Variable blockIndex = compilerContext.getVariable("leftBlockIndex");
            ByteCodeExpression leftBlock = compilerContext.getVariable("this").getField(joinChannelFields.get(index)).invoke("get", Object.class, blockIndex).cast(Block.class);
            ByteCodeExpression rightBlock = compilerContext.getVariable("this").getField(joinChannelFields.get(index)).invoke("get", Object.class, compilerContext.getVariable("rightBlockIndex")).cast(Block.class);
            LabelNode checkNextField = new LabelNode("checkNextField");
            hashPositionMethod.getBody().append(JoinCompiler.typeEquals(compilerContext, type, leftBlock, compilerContext.getVariable("leftBlockPosition"), rightBlock, compilerContext.getVariable("rightBlockPosition"))).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        hashPositionMethod.getBody().push(true).retInt();
    }

    private static ByteCodeNode typeEquals(CompilerContext compilerContext, ByteCodeExpression type, ByteCodeExpression leftBlock, ByteCodeExpression leftBlockPosition, ByteCodeExpression rightBlock, ByteCodeExpression rightBlockPosition) {
        IfStatement.IfStatementBuilder ifStatementBuilder = new IfStatement.IfStatementBuilder(compilerContext);
        ifStatementBuilder.condition(new com.facebook.presto.byteCode.Block(compilerContext).append(leftBlock.invoke("isNull", Boolean.TYPE, leftBlockPosition)).append(rightBlock.invoke("isNull", Boolean.TYPE, rightBlockPosition)).append(OpCode.IOR));
        ifStatementBuilder.ifTrue(new com.facebook.presto.byteCode.Block(compilerContext).append(leftBlock.invoke("isNull", Boolean.TYPE, leftBlockPosition)).append(rightBlock.invoke("isNull", Boolean.TYPE, rightBlockPosition)).append(OpCode.IAND));
        ifStatementBuilder.ifFalse(new com.facebook.presto.byteCode.Block(compilerContext).append(type.invoke("equalTo", Boolean.TYPE, leftBlock, leftBlockPosition, rightBlock, rightBlockPosition)));
        return ifStatementBuilder.build();
    }

    private static final class CacheKey {
        private final List<Type> types;
        private final List<Integer> joinChannels;

        private CacheKey(List<? extends Type> types, List<Integer> joinChannels) {
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
            this.joinChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(joinChannels, (Object)"joinChannels is null")));
        }

        private List<Type> getTypes() {
            return this.types;
        }

        private List<Integer> getJoinChannels() {
            return this.joinChannels;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.types, this.joinChannels});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Objects.equal(this.types, other.types) && Objects.equal(this.joinChannels, other.joinChannels);
        }
    }

    public static class PagesHashStrategyFactory {
        private final Constructor<? extends PagesHashStrategy> constructor;

        public PagesHashStrategyFactory(Class<? extends PagesHashStrategy> pagesHashStrategyClass) {
            try {
                this.constructor = pagesHashStrategyClass.getConstructor(List.class, Optional.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public PagesHashStrategy createPagesHashStrategy(List<? extends List<Block>> channels, Optional<Integer> hashChannel) {
            try {
                return this.constructor.newInstance(channels, hashChannel);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static class LookupSourceFactory {
        private final Constructor<? extends LookupSource> constructor;
        private final PagesHashStrategyFactory pagesHashStrategyFactory;

        public LookupSourceFactory(Class<? extends LookupSource> lookupSourceClass, PagesHashStrategyFactory pagesHashStrategyFactory) {
            this.pagesHashStrategyFactory = pagesHashStrategyFactory;
            try {
                this.constructor = lookupSourceClass.getConstructor(LongArrayList.class, List.class, PagesHashStrategy.class, OperatorContext.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public LookupSource createLookupSource(LongArrayList addresses, List<Type> types, List<List<Block>> channels, Optional<Integer> hashChannel, OperatorContext operatorContext) {
            PagesHashStrategy pagesHashStrategy = this.pagesHashStrategyFactory.createPagesHashStrategy(channels, hashChannel);
            try {
                return this.constructor.newInstance(addresses, types, pagesHashStrategy, operatorContext);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

