/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.ByteCodeExpressionVisitor;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.primitives.Primitives;
import java.util.List;

public class CursorProcessorCompiler
implements BodyCompiler<CursorProcessor> {
    private final Metadata metadata;

    public CursorProcessorCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<RowExpression> projections) {
        this.generateProcessMethod(classDefinition, projections.size());
        this.generateFilterMethod(classDefinition, callSiteBinder, filter);
        for (int i = 0; i < projections.size(); ++i) {
            this.generateProjectMethod(classDefinition, callSiteBinder, "project_" + i, projections.get(i));
        }
    }

    private void generateProcessMethod(ClassDefinition classDefinition, int projections) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition method = classDefinition.declareMethod(context, Access.a(Access.PUBLIC), "process", ParameterizedType.type(Integer.TYPE), NamedParameterDefinition.arg("session", ConnectorSession.class), NamedParameterDefinition.arg("cursor", RecordCursor.class), NamedParameterDefinition.arg("count", Integer.TYPE), NamedParameterDefinition.arg("pageBuilder", PageBuilder.class));
        Variable sessionVariable = context.getVariable("session");
        Variable cursorVariable = context.getVariable("cursor");
        Variable countVariable = context.getVariable("count");
        Variable pageBuilderVariable = context.getVariable("pageBuilder");
        Variable completedPositionsVariable = context.declareVariable(Integer.TYPE, "completedPositions");
        method.getBody().comment("int completedPositions = 0;").putVariable(completedPositionsVariable, 0);
        LabelNode done = new LabelNode("done");
        ForLoop.ForLoopBuilder forLoop = ForLoop.forLoopBuilder(context).initialize(OpCode.NOP).condition(new Block(context).comment("completedPositions < count").getVariable(completedPositionsVariable).getVariable(countVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new Block(context).comment("completedPositions++").incrementVariable(completedPositionsVariable, (byte)1));
        Block forLoopBody = new Block(context).comment("if (pageBuilder.isFull()) break;").append(new Block(context).getVariable(pageBuilderVariable).invokeVirtual(PageBuilder.class, "isFull", Boolean.TYPE, new Class[0]).ifTrueGoto(done)).comment("if (!cursor.advanceNextPosition()) break;").append(new Block(context).getVariable(cursorVariable).invokeInterface(RecordCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).ifFalseGoto(done));
        forLoop.body(forLoopBody);
        IfStatement.IfStatementBuilder ifStatement = new IfStatement.IfStatementBuilder(context);
        ifStatement.condition(new Block(context).pushThis().getVariable(sessionVariable).getVariable(cursorVariable).invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), ParameterizedType.type(ConnectorSession.class), ParameterizedType.type(RecordCursor.class)));
        Block trueBlock = new Block(context);
        ifStatement.ifTrue(trueBlock);
        trueBlock.getVariable(pageBuilderVariable).invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        for (int projectionIndex = 0; projectionIndex < projections; ++projectionIndex) {
            trueBlock.pushThis().getVariable(sessionVariable).getVariable(cursorVariable);
            trueBlock.getVariable(pageBuilderVariable).push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE);
            trueBlock.invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), ParameterizedType.type(ConnectorSession.class), ParameterizedType.type(RecordCursor.class), ParameterizedType.type(BlockBuilder.class));
        }
        forLoopBody.append(ifStatement.build());
        method.getBody().append(forLoop.build()).visitLabel(done).comment("return completedPositions;").getVariable(completedPositionsVariable).retInt();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition method = classDefinition.declareMethod(context, Access.a(Access.PUBLIC), "filter", ParameterizedType.type(Boolean.TYPE), NamedParameterDefinition.arg("session", ConnectorSession.class), NamedParameterDefinition.arg("cursor", RecordCursor.class));
        method.comment("Filter: %s", filter);
        Variable wasNullVariable = context.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        Variable cursorVariable = context.getVariable("cursor");
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, this.fieldReferenceCompiler(cursorVariable, wasNullVariable), this.metadata.getFunctionRegistry());
        LabelNode end = new LabelNode("end");
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).comment("evaluate filter: " + filter).append(filter.accept(visitor, context)).comment("if (wasNull) return false;").getVariable(wasNullVariable).ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
    }

    private void generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String methodName, RowExpression projection) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition method = classDefinition.declareMethod(context, Access.a(Access.PUBLIC), methodName, ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("session", ConnectorSession.class), NamedParameterDefinition.arg("cursor", RecordCursor.class), NamedParameterDefinition.arg("output", BlockBuilder.class));
        method.comment("Projection: %s", projection.toString());
        Variable outputVariable = context.getVariable("output");
        Variable cursorVariable = context.getVariable("cursor");
        Variable wasNullVariable = context.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        Block body = method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false);
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, this.fieldReferenceCompiler(cursorVariable, wasNullVariable), this.metadata.getFunctionRegistry());
        body.getVariable(outputVariable).comment("evaluate projection: " + projection.toString()).append(projection.accept(visitor, context)).append(ByteCodeUtils.generateWrite(callSiteBinder, context, wasNullVariable, projection.getType())).ret();
    }

    private RowExpressionVisitor<CompilerContext, ByteCodeNode> fieldReferenceCompiler(final Variable cursorVariable, final Variable wasNullVariable) {
        return new RowExpressionVisitor<CompilerContext, ByteCodeNode>(){

            @Override
            public ByteCodeNode visitInputReference(InputReferenceExpression node, CompilerContext context) {
                int field = node.getField();
                Type type = node.getType();
                Class javaType = type.getJavaType();
                Block isNullCheck = new Block(context).setDescription(String.format("cursor.get%s(%d)", type, field)).getVariable(cursorVariable).push(field).invokeInterface(RecordCursor.class, "isNull", Boolean.TYPE, Integer.TYPE);
                Block isNull = new Block(context).putVariable(wasNullVariable, true).pushJavaDefault(javaType);
                Block isNotNull = new Block(context).getVariable(cursorVariable).push(field);
                String methodName = "get" + Primitives.wrap((Class)javaType).getSimpleName();
                isNotNull.invokeInterface(RecordCursor.class, methodName, javaType, Integer.TYPE);
                return new IfStatement(context, isNullCheck, isNull, isNotNull);
            }

            @Override
            public ByteCodeNode visitCall(CallExpression call, CompilerContext context) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public ByteCodeNode visitConstant(ConstantExpression literal, CompilerContext context) {
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }
}

