/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;

public final class ByteCodeUtils {
    private ByteCodeUtils() {
    }

    public static ByteCodeNode ifWasNullPopAndGoto(CompilerContext context, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return ByteCodeUtils.handleNullValue(context, label, returnType, ImmutableList.copyOf((Object[])stackArgsToPop), false);
    }

    public static ByteCodeNode ifWasNullPopAndGoto(CompilerContext context, LabelNode label, Class<?> returnType, Iterable<? extends Class<?>> stackArgsToPop) {
        return ByteCodeUtils.handleNullValue(context, label, returnType, ImmutableList.copyOf(stackArgsToPop), false);
    }

    public static ByteCodeNode ifWasNullClearPopAndGoto(CompilerContext context, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return ByteCodeUtils.handleNullValue(context, label, returnType, ImmutableList.copyOf((Object[])stackArgsToPop), true);
    }

    public static ByteCodeNode handleNullValue(CompilerContext context, LabelNode label, Class<?> returnType, List<Class<?>> stackArgsToPop, boolean clearNullFlag) {
        Block nullCheck = new Block(context).setDescription("ifWasNullGoto").getVariable("wasNull");
        String clearComment = null;
        if (clearNullFlag) {
            nullCheck.putVariable("wasNull", false);
            clearComment = "clear wasNull";
        }
        Block isNull = new Block(context);
        for (Class<?> parameterType : stackArgsToPop) {
            isNull.pop(parameterType);
        }
        isNull.pushJavaDefault(returnType);
        String loadDefaultComment = null;
        if (returnType != Void.TYPE) {
            loadDefaultComment = String.format("loadJavaDefault(%s)", returnType.getName());
        }
        isNull.gotoLabel(label);
        String popComment = null;
        if (!stackArgsToPop.isEmpty()) {
            popComment = String.format("pop(%s)", Joiner.on((String)", ").join(stackArgsToPop));
        }
        String comment = String.format("if wasNull then %s", Joiner.on((String)", ").skipNulls().join((Object)clearComment, (Object)popComment, new Object[]{loadDefaultComment, "goto " + label.getLabel()}));
        return new IfStatement(context, comment, nullCheck, isNull, OpCode.NOP);
    }

    public static ByteCodeNode boxPrimitive(CompilerContext context, Class<?> type) {
        Block block = new Block(context).comment("box primitive");
        if (type == Long.TYPE) {
            return block.invokeStatic(Long.class, "valueOf", Long.class, Long.TYPE);
        }
        if (type == Double.TYPE) {
            return block.invokeStatic(Double.class, "valueOf", Double.class, Double.TYPE);
        }
        if (type == Boolean.TYPE) {
            return block.invokeStatic(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
        }
        if (type.isPrimitive()) {
            throw new UnsupportedOperationException("not yet implemented: " + type);
        }
        return OpCode.NOP;
    }

    public static ByteCodeNode unboxPrimitive(CompilerContext context, Class<?> unboxedType) {
        Block block = new Block(context).comment("unbox primitive");
        if (unboxedType == Long.TYPE) {
            return block.invokeVirtual(Long.class, "longValue", Long.TYPE, new Class[0]);
        }
        if (unboxedType == Double.TYPE) {
            return block.invokeVirtual(Double.class, "doubleValue", Double.TYPE, new Class[0]);
        }
        if (unboxedType == Boolean.TYPE) {
            return block.invokeVirtual(Boolean.class, "booleanValue", Boolean.TYPE, new Class[0]);
        }
        throw new UnsupportedOperationException("not yet implemented: " + unboxedType);
    }

    public static ByteCodeExpression loadConstant(CompilerContext context, CallSiteBinder callSiteBinder, Object constant, Class<?> type) {
        Binding binding = callSiteBinder.bind(MethodHandles.constant(type, constant));
        return ByteCodeUtils.loadConstant(context, binding);
    }

    public static ByteCodeExpression loadConstant(CompilerContext context, Binding binding) {
        return ByteCodeExpressions.invokeDynamic(context.getDefaultBootstrapMethod(), (Iterable<? extends Object>)ImmutableList.of((Object)binding.getBindingId()), "constant_" + binding.getBindingId(), binding.getType().returnType(), new ByteCodeExpression[0]);
    }

    public static ByteCodeNode generateInvocation(CompilerContext context, FunctionInfo function, List<ByteCodeNode> arguments, Binding binding) {
        MethodType methodType = binding.getType();
        Signature signature = function.getSignature();
        Class unboxedReturnType = Primitives.unwrap((Class)methodType.returnType());
        LabelNode end = new LabelNode("end");
        Block block = new Block(context).setDescription("invoke " + signature);
        ArrayList stackTypes = new ArrayList();
        int index = 0;
        for (Class<?> type : methodType.parameterArray()) {
            stackTypes.add(type);
            if (type == ConnectorSession.class) {
                block.getVariable("session");
                continue;
            }
            block.append(arguments.get(index));
            if (!function.getNullableArguments().get(index).booleanValue()) {
                block.append(ByteCodeUtils.ifWasNullPopAndGoto(context, end, unboxedReturnType, Lists.reverse(stackTypes)));
            } else {
                block.append(ByteCodeUtils.boxPrimitiveIfNecessary(context, type));
                block.putVariable("wasNull", false);
            }
            ++index;
        }
        block.append(ByteCodeUtils.invoke(context, binding, function.getSignature()));
        if (function.isNullable()) {
            if (unboxedReturnType.isPrimitive() && unboxedReturnType != Void.TYPE) {
                LabelNode notNull = new LabelNode("notNull");
                block.dup((Class<?>)methodType.returnType()).ifNotNullGoto(notNull).putVariable("wasNull", true).comment("swap boxed null with unboxed default").pop((Class<?>)methodType.returnType()).pushJavaDefault(unboxedReturnType).gotoLabel(end).visitLabel(notNull).append(ByteCodeUtils.unboxPrimitive(context, unboxedReturnType));
            } else {
                block.dup((Class<?>)methodType.returnType()).ifNotNullGoto(end).putVariable("wasNull", true);
            }
        }
        block.visitLabel(end);
        return block;
    }

    public static ByteCodeNode boxPrimitiveIfNecessary(CompilerContext context, Class<?> type) {
        Class<Object> expectedCurrentStackType;
        if (!Primitives.isWrapperType(type)) {
            return OpCode.NOP;
        }
        Block notNull = new Block(context).comment("box primitive");
        if (type == Long.class) {
            notNull.invokeStatic(Long.class, "valueOf", Long.class, Long.TYPE);
            expectedCurrentStackType = Long.TYPE;
        } else if (type == Double.class) {
            notNull.invokeStatic(Double.class, "valueOf", Double.class, Double.TYPE);
            expectedCurrentStackType = Double.TYPE;
        } else if (type == Boolean.class) {
            notNull.invokeStatic(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
            expectedCurrentStackType = Boolean.TYPE;
        } else if (type == Void.class) {
            notNull.pushNull().checkCast(Void.class);
            expectedCurrentStackType = Void.TYPE;
        } else {
            throw new UnsupportedOperationException("not yet implemented: " + type);
        }
        Block condition = new Block(context).getVariable("wasNull");
        Block wasNull = new Block(context).pop(expectedCurrentStackType).pushNull().checkCast(type);
        return IfStatement.ifStatementBuilder(context).condition(condition).ifTrue(wasNull).ifFalse(notNull).build();
    }

    public static ByteCodeNode invoke(CompilerContext context, Binding binding, String name) {
        return new Block(context).invokeDynamic(name, binding.getType(), binding.getBindingId());
    }

    public static ByteCodeNode invoke(CompilerContext context, Binding binding, Signature signature) {
        return ByteCodeUtils.invoke(context, binding, signature.getName());
    }

    public static ByteCodeNode generateWrite(CallSiteBinder callSiteBinder, CompilerContext context, Variable wasNullVariable, Type type) {
        if (type.getJavaType() == Void.TYPE) {
            return new Block(context).comment("output.appendNull();").invokeInterface(BlockBuilder.class, "appendNull", BlockBuilder.class, new Class[0]).pop();
        }
        String methodName = "write" + Primitives.wrap((Class)type.getJavaType()).getSimpleName();
        Variable tempValue = context.createTempVariable(type.getJavaType());
        Variable tempOutput = context.createTempVariable(BlockBuilder.class);
        return new Block(context).comment("if (wasNull)").append(new IfStatement.IfStatementBuilder(context).condition(new Block(context).getVariable(wasNullVariable)).ifTrue(new Block(context).comment("output.appendNull();").pop(type.getJavaType()).invokeInterface(BlockBuilder.class, "appendNull", BlockBuilder.class, new Class[0]).pop()).ifFalse(new Block(context).comment(type.getTypeSignature() + "." + methodName + "(output, " + type.getJavaType().getSimpleName() + ")").putVariable(tempValue).putVariable(tempOutput).append(ByteCodeUtils.loadConstant(context, callSiteBinder.bind(type, Type.class))).getVariable(tempOutput).getVariable(tempValue).invokeInterface(Type.class, methodName, Void.TYPE, BlockBuilder.class, type.getJavaType())).build());
    }
}

