/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class FieldOrExpression {
    private final Optional<Integer> fieldIndex;
    private final Optional<Expression> expression;

    public FieldOrExpression(int fieldIndex) {
        this.fieldIndex = Optional.of(fieldIndex);
        this.expression = Optional.empty();
    }

    public FieldOrExpression(Expression expression) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression is null");
        this.fieldIndex = Optional.empty();
        this.expression = Optional.of(expression);
    }

    public boolean isFieldReference() {
        return this.fieldIndex.isPresent();
    }

    public int getFieldIndex() {
        Preconditions.checkState((boolean)this.isFieldReference(), (Object)"Not a field reference");
        return this.fieldIndex.get();
    }

    public boolean isExpression() {
        return this.expression.isPresent();
    }

    public Expression getExpression() {
        Preconditions.checkState((boolean)this.isExpression(), (Object)"Not an expression");
        return this.expression.get();
    }

    public String toString() {
        if (this.fieldIndex.isPresent()) {
            return this.fieldIndex.get().toString();
        }
        return this.expression.get().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldOrExpression that = (FieldOrExpression)o;
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return this.fieldIndex.equals(that.fieldIndex);
    }

    public int hashCode() {
        int result = this.fieldIndex.hashCode();
        result = 31 * result + this.expression.hashCode();
        return result;
    }
}

