/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.connector.system.SystemRecordSetProvider;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.split.RecordPageSourceProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class PageSourceManager
implements PageSourceProvider {
    private final ConcurrentMap<String, ConnectorPageSourceProvider> pageSourceProviders = new ConcurrentHashMap<String, ConnectorPageSourceProvider>();

    @Inject
    public PageSourceManager(SystemRecordSetProvider systemRecordSetProvider) {
        this.pageSourceProviders.put("system", new RecordPageSourceProvider(systemRecordSetProvider));
    }

    public void addConnectorPageSourceProvider(String connectorId, ConnectorPageSourceProvider connectorPageSourceProvider) {
        this.pageSourceProviders.put(connectorId, connectorPageSourceProvider);
    }

    @Override
    public ConnectorPageSource createPageSource(Split split, List<ColumnHandle> columns) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        List handles = Lists.transform(columns, ColumnHandle::getConnectorHandle);
        return this.getPageSourceProvider(split).createPageSource(split.getConnectorSplit(), handles);
    }

    private ConnectorPageSourceProvider getPageSourceProvider(Split split) {
        ConnectorPageSourceProvider provider = (ConnectorPageSourceProvider)this.pageSourceProviders.get(split.getConnectorId());
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"No page stream provider for '%s", (Object[])new Object[]{split.getConnectorId()});
        return provider;
    }
}

