/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.window.ValueWindowFunction;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.Failures;
import com.google.common.primitives.Ints;
import java.util.List;

public class NthValueFunction
extends ValueWindowFunction {
    private final Type type;
    private final int valueChannel;
    private final int offsetChannel;

    protected NthValueFunction(Type type, List<Integer> argumentChannels) {
        this.type = type;
        this.valueChannel = argumentChannels.get(0);
        this.offsetChannel = argumentChannels.get(1);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        if (frameStart < 0 || this.windowIndex.isNull(this.offsetChannel, currentPosition)) {
            output.appendNull();
        } else {
            long offset = this.windowIndex.getLong(this.offsetChannel, currentPosition);
            Failures.checkCondition(offset >= 1L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Offset must be at least 1", new Object[0]);
            long valuePosition = (long)frameStart + (offset - 1L);
            if (valuePosition >= (long)frameStart && valuePosition <= (long)frameEnd) {
                this.windowIndex.appendTo(this.valueChannel, Ints.checkedCast((long)valuePosition), output);
            } else {
                output.appendNull();
            }
        }
    }

    public static class VarcharNthValueFunction
    extends NthValueFunction {
        public VarcharNthValueFunction(List<Integer> argumentChannels) {
            super((Type)VarcharType.VARCHAR, argumentChannels);
        }
    }

    public static class DoubleNthValueFunction
    extends NthValueFunction {
        public DoubleNthValueFunction(List<Integer> argumentChannels) {
            super((Type)DoubleType.DOUBLE, argumentChannels);
        }
    }

    public static class BooleanNthValueFunction
    extends NthValueFunction {
        public BooleanNthValueFunction(List<Integer> argumentChannels) {
            super((Type)BooleanType.BOOLEAN, argumentChannels);
        }
    }

    public static class BigintNthValueFunction
    extends NthValueFunction {
        public BigintNthValueFunction(List<Integer> argumentChannels) {
            super((Type)BigintType.BIGINT, argumentChannels);
        }
    }
}

