/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.window.ValueWindowFunction;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.Iterables;
import java.util.List;

public class LastValueFunction
extends ValueWindowFunction {
    private final Type type;
    private final int argumentChannel;

    protected LastValueFunction(Type type, List<Integer> argumentChannels) {
        this.type = type;
        this.argumentChannel = (Integer)Iterables.getOnlyElement(argumentChannels);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        if (frameStart < 0) {
            output.appendNull();
            return;
        }
        this.windowIndex.appendTo(this.argumentChannel, frameEnd, output);
    }

    public static class VarcharLastValueFunction
    extends LastValueFunction {
        public VarcharLastValueFunction(List<Integer> argumentChannels) {
            super((Type)VarcharType.VARCHAR, argumentChannels);
        }
    }

    public static class DoubleLastValueFunction
    extends LastValueFunction {
        public DoubleLastValueFunction(List<Integer> argumentChannels) {
            super((Type)DoubleType.DOUBLE, argumentChannels);
        }
    }

    public static class BooleanLastValueFunction
    extends LastValueFunction {
        public BooleanLastValueFunction(List<Integer> argumentChannels) {
            super((Type)BooleanType.BOOLEAN, argumentChannels);
        }
    }

    public static class BigintLastValueFunction
    extends LastValueFunction {
        public BigintLastValueFunction(List<Integer> argumentChannels) {
            super((Type)BigintType.BIGINT, argumentChannels);
        }
    }
}

