/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.type.SqlType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Throwables;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class TestingRowConstructor {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new SliceSerializer()));

    private TestingRowConstructor() {
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<bigint,bigint>('col0','col1')")
    public static Slice testRowBigintBigint(@Nullable @SqlType(value="bigint") Long arg1, @Nullable @SqlType(value="bigint") Long arg2) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<bigint,double>('col0','col1')")
    public static Slice testRowBigintBigint(@Nullable @SqlType(value="bigint") Long arg1, @Nullable @SqlType(value="double") Double arg2) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<bigint,double,boolean,varchar,timestamp>('col0','col1','col2','col3','col4')")
    public static Slice testRowBigintDoubleBooleanVarcharTimestamp(@Nullable @SqlType(value="bigint") Long arg1, @Nullable @SqlType(value="double") Double arg2, @Nullable @SqlType(value="boolean") Boolean arg3, @Nullable @SqlType(value="varchar") Slice arg4, @Nullable @SqlType(value="timestamp") Long arg5) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2, arg3, arg4, arg5);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<HyperLogLog>('col0')")
    public static Slice testRowHyperLogLog(@Nullable @SqlType(value="HyperLogLog") Slice arg1) {
        return TestingRowConstructor.toStackRepresentation(arg1);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<double,row<timestamp with time zone,timestamp with time zone>('col0','col1')>('col2','col3')")
    public static Slice testNestedRowsWithTimestampsWithTimeZones(@Nullable @SqlType(value="double") Double arg1, @Nullable @SqlType(value="row<timestamp with time zone,timestamp with time zone>('col0','col1')") Slice arg2) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<timestamp with time zone,timestamp with time zone>('col0','col1')")
    public static Slice testRowTimestampsWithTimeZones(@Nullable @SqlType(value="timestamp with time zone") Long arg1, @Nullable @SqlType(value="timestamp with time zone") Long arg2) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<double,double>('col0','col1')")
    public static Slice testRowBigintBigint(@Nullable @SqlType(value="double") Double arg1, @Nullable @SqlType(value="double") Double arg2) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<double,varchar>('col0','col1')")
    public static Slice testRowBigintBigint(@Nullable @SqlType(value="double") Double arg1, @Nullable @SqlType(value="varchar") Slice arg2) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<boolean,boolean>('col0','col1')")
    public static Slice testRowBigintBigint(@Nullable @SqlType(value="boolean") Boolean arg1, @Nullable @SqlType(value="boolean") Boolean arg2) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<boolean,boolean,boolean,boolean>('col0','col1','col2','col3')")
    public static Slice testRowFourBooleans(@Nullable @SqlType(value="boolean") Boolean arg1, @Nullable @SqlType(value="boolean") Boolean arg2, @Nullable @SqlType(value="boolean") Boolean arg3, @Nullable @SqlType(value="boolean") Boolean arg4) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2, arg3, arg4);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<boolean,array<bigint>>('col0','col1')")
    public static Slice testRowBooleanArray(@Nullable @SqlType(value="boolean") Boolean arg1, @Nullable @SqlType(value="array<bigint>") Slice arg2) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<boolean,array<bigint>,map<bigint,double>>('col0','col1','col2')")
    public static Slice testRowBooleanArrayMap(@Nullable @SqlType(value="boolean") Boolean arg1, @Nullable @SqlType(value="array<bigint>") Slice arg2, @Nullable @SqlType(value="map<bigint,double>") Slice arg3) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2, arg3);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<double,array<bigint>,row<bigint,double>('col0','col1')>('col0','col1','col2')")
    public static Slice testNestedRow(@Nullable @SqlType(value="double") Double arg1, @Nullable @SqlType(value="array<bigint>") Slice arg2, @Nullable @SqlType(value="row<bigint,double>('col0','col1')") Slice arg3) {
        return TestingRowConstructor.toStackRepresentation(arg1, arg2, arg3);
    }

    @ScalarFunction(value="test_row")
    @SqlType(value="row<timestamp>('col0')")
    public static Slice testRowBigintBigint(@Nullable @SqlType(value="timestamp") Long arg1) {
        return TestingRowConstructor.toStackRepresentation(arg1);
    }

    private static Slice toStackRepresentation(Object ... values) {
        try {
            return Slices.utf8Slice((String)OBJECT_MAPPER.writeValueAsString(Arrays.asList(values)));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

