/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.JsonExtract;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RowFieldAccessor
extends ParametricScalar {
    private static final Map<String, MethodHandle> METHOD_HANDLE_MAP;
    private final Signature signature;
    private final MethodHandle methodHandle;

    public RowFieldAccessor(RowType type, String fieldName) {
        JsonExtract.JsonExtractor<Slice> extractor;
        Type returnType = null;
        int index = 0;
        for (RowType.RowField field : type.getFields()) {
            if (field.getName().equals(Optional.of(fieldName))) {
                returnType = field.getType();
                break;
            }
            ++index;
        }
        Preconditions.checkNotNull((Object)returnType, (String)"%s not found in row type %s", (Object[])new Object[]{fieldName, type});
        this.signature = new Signature(FunctionRegistry.mangleFieldAccessor(fieldName), returnType.getTypeSignature(), type.getTypeSignature());
        if (returnType instanceof ArrayType || returnType instanceof MapType || returnType instanceof RowType) {
            extractor = new JsonExtract.JsonValueJsonExtractor();
        } else if (returnType.getJavaType() == Boolean.TYPE) {
            extractor = new JsonExtract.BooleanJsonExtractor();
        } else if (returnType.getJavaType() == Long.TYPE) {
            extractor = new JsonExtract.LongJsonExtractor();
        } else if (returnType.getJavaType() == Double.TYPE) {
            extractor = new JsonExtract.DoubleJsonExtractor();
        } else if (returnType.getJavaType() == Slice.class) {
            extractor = new JsonExtract.ScalarValueJsonExtractor();
        } else {
            throw new IllegalArgumentException("Unsupported stack type: " + returnType.getJavaType());
        }
        extractor = JsonExtract.generateExtractor(String.format("$[%d]", index), extractor, true);
        String stackType = returnType.getJavaType().getSimpleName().toLowerCase();
        Preconditions.checkState((boolean)METHOD_HANDLE_MAP.containsKey(stackType), (String)"method handle missing for %s stack type", (Object[])new Object[]{stackType});
        this.methodHandle = METHOD_HANDLE_MAP.get(stackType).bindTo(extractor);
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkNotNull((Object)this.methodHandle, (Object)"methodHandle is null");
        return new FunctionInfo(this.signature, this.getDescription(), this.isHidden(), this.methodHandle, this.isDeterministic(), true, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static Long longAccessor(JsonExtract.JsonExtractor<Long> extractor, Slice row) {
        return JsonExtract.extract(row, extractor);
    }

    public static Boolean booleanAccessor(JsonExtract.JsonExtractor<Boolean> extractor, Slice row) {
        return JsonExtract.extract(row, extractor);
    }

    public static Double doubleAccessor(JsonExtract.JsonExtractor<Double> extractor, Slice row) {
        return JsonExtract.extract(row, extractor);
    }

    public static Slice sliceAccessor(JsonExtract.JsonExtractor<Slice> extractor, Slice row) {
        return JsonExtract.extract(row, extractor);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"long", (Object)Reflection.methodHandle(RowFieldAccessor.class, "longAccessor", JsonExtract.JsonExtractor.class, Slice.class));
        builder.put((Object)"double", (Object)Reflection.methodHandle(RowFieldAccessor.class, "doubleAccessor", JsonExtract.JsonExtractor.class, Slice.class));
        builder.put((Object)"boolean", (Object)Reflection.methodHandle(RowFieldAccessor.class, "booleanAccessor", JsonExtract.JsonExtractor.class, Slice.class));
        builder.put((Object)"slice", (Object)Reflection.methodHandle(RowFieldAccessor.class, "sliceAccessor", JsonExtract.JsonExtractor.class, Slice.class));
        METHOD_HANDLE_MAP = builder.build();
    }
}

