/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.type.SqlType;
import com.google.common.primitives.Doubles;
import java.util.concurrent.ThreadLocalRandom;

public final class MathFunctions {
    private MathFunctions() {
    }

    @Description(value="absolute value")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long abs(@SqlType(value="bigint") long num) {
        return Math.abs(num);
    }

    @Description(value="absolute value")
    @ScalarFunction
    @SqlType(value="double")
    public static double abs(@SqlType(value="double") double num) {
        return Math.abs(num);
    }

    @Description(value="arc cosine")
    @ScalarFunction
    @SqlType(value="double")
    public static double acos(@SqlType(value="double") double num) {
        return Math.acos(num);
    }

    @Description(value="arc sine")
    @ScalarFunction
    @SqlType(value="double")
    public static double asin(@SqlType(value="double") double num) {
        return Math.asin(num);
    }

    @Description(value="arc tangent")
    @ScalarFunction
    @SqlType(value="double")
    public static double atan(@SqlType(value="double") double num) {
        return Math.atan(num);
    }

    @Description(value="arc tangent of given fraction")
    @ScalarFunction
    @SqlType(value="double")
    public static double atan2(@SqlType(value="double") double num1, @SqlType(value="double") double num2) {
        return Math.atan2(num1, num2);
    }

    @Description(value="cube root")
    @ScalarFunction
    @SqlType(value="double")
    public static double cbrt(@SqlType(value="double") double num) {
        return Math.cbrt(num);
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(alias={"ceil"})
    @SqlType(value="bigint")
    public static long ceiling(@SqlType(value="bigint") long num) {
        return num;
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(alias={"ceil"})
    @SqlType(value="double")
    public static double ceiling(@SqlType(value="double") double num) {
        return Math.ceil(num);
    }

    @Description(value="cosine")
    @ScalarFunction
    @SqlType(value="double")
    public static double cos(@SqlType(value="double") double num) {
        return Math.cos(num);
    }

    @Description(value="hyperbolic cosine")
    @ScalarFunction
    @SqlType(value="double")
    public static double cosh(@SqlType(value="double") double num) {
        return Math.cosh(num);
    }

    @Description(value="Euler's number")
    @ScalarFunction
    @SqlType(value="double")
    public static double e() {
        return Math.E;
    }

    @Description(value="Euler's number raised to the given power")
    @ScalarFunction
    @SqlType(value="double")
    public static double exp(@SqlType(value="double") double num) {
        return Math.exp(num);
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long floor(@SqlType(value="bigint") long num) {
        return num;
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction
    @SqlType(value="double")
    public static double floor(@SqlType(value="double") double num) {
        return Math.floor(num);
    }

    @Description(value="natural logarithm")
    @ScalarFunction
    @SqlType(value="double")
    public static double ln(@SqlType(value="double") double num) {
        return Math.log(num);
    }

    @Description(value="logarithm to base 2")
    @ScalarFunction
    @SqlType(value="double")
    public static double log2(@SqlType(value="double") double num) {
        return Math.log(num) / Math.log(2.0);
    }

    @Description(value="logarithm to base 10")
    @ScalarFunction
    @SqlType(value="double")
    public static double log10(@SqlType(value="double") double num) {
        return Math.log10(num);
    }

    @Description(value="logarithm to given base")
    @ScalarFunction
    @SqlType(value="double")
    public static double log(@SqlType(value="double") double num, @SqlType(value="double") double base) {
        return Math.log(num) / Math.log(base);
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long mod(@SqlType(value="bigint") long num1, @SqlType(value="bigint") long num2) {
        return num1 % num2;
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction
    @SqlType(value="double")
    public static double mod(@SqlType(value="double") double num1, @SqlType(value="double") double num2) {
        return num1 % num2;
    }

    @Description(value="the constant Pi")
    @ScalarFunction
    @SqlType(value="double")
    public static double pi() {
        return Math.PI;
    }

    @Description(value="value raised to the power of exponent")
    @ScalarFunction
    @SqlType(value="double")
    public static double pow(@SqlType(value="double") double num, @SqlType(value="double") double exponent) {
        return Math.pow(num, exponent);
    }

    @Description(value="a pseudo-random value")
    @ScalarFunction(alias={"rand"}, deterministic=false)
    @SqlType(value="double")
    public static double random() {
        return ThreadLocalRandom.current().nextDouble();
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long round(@SqlType(value="bigint") long num) {
        return MathFunctions.round(num, 0L);
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long round(@SqlType(value="bigint") long num, @SqlType(value="bigint") long decimals) {
        return num;
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    @SqlType(value="double")
    public static double round(@SqlType(value="double") double num) {
        return MathFunctions.round(num, 0L);
    }

    @Description(value="round to given number of decimal places")
    @ScalarFunction
    @SqlType(value="double")
    public static double round(@SqlType(value="double") double num, @SqlType(value="bigint") long decimals) {
        if (num == 0.0) {
            return 0.0;
        }
        if (num < 0.0) {
            return -MathFunctions.round(-num, decimals);
        }
        double factor = Math.pow(10.0, decimals);
        return Math.floor(num * factor + 0.5) / factor;
    }

    @Description(value="sine")
    @ScalarFunction
    @SqlType(value="double")
    public static double sin(@SqlType(value="double") double num) {
        return Math.sin(num);
    }

    @Description(value="square root")
    @ScalarFunction
    @SqlType(value="double")
    public static double sqrt(@SqlType(value="double") double num) {
        return Math.sqrt(num);
    }

    @Description(value="tangent")
    @ScalarFunction
    @SqlType(value="double")
    public static double tan(@SqlType(value="double") double num) {
        return Math.tan(num);
    }

    @Description(value="hyperbolic tangent")
    @ScalarFunction
    @SqlType(value="double")
    public static double tanh(@SqlType(value="double") double num) {
        return Math.tanh(num);
    }

    @Description(value="test if value is not-a-number")
    @ScalarFunction(value="is_nan")
    @SqlType(value="boolean")
    public static boolean isNaN(@SqlType(value="double") double num) {
        return Double.isNaN(num);
    }

    @Description(value="test if value is finite")
    @ScalarFunction
    @SqlType(value="boolean")
    public static boolean isFinite(@SqlType(value="double") double num) {
        return Doubles.isFinite((double)num);
    }

    @Description(value="test if value is infinite")
    @ScalarFunction
    @SqlType(value="boolean")
    public static boolean isInfinite(@SqlType(value="double") double num) {
        return Double.isInfinite(num);
    }

    @Description(value="constant representing not-a-number")
    @ScalarFunction(value="nan")
    @SqlType(value="double")
    public static double NaN() {
        return Double.NaN;
    }

    @Description(value="Infinity")
    @ScalarFunction
    @SqlType(value="double")
    public static double infinity() {
        return Double.POSITIVE_INFINITY;
    }
}

