/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.JsonExtract;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MapSubscriptOperator
extends ParametricOperator {
    public static final MapSubscriptOperator MAP_SUBSCRIPT = new MapSubscriptOperator();
    private static final LoadingCache<CacheKey, JsonExtract.JsonExtractor<?>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(1000L).build(new CacheLoader<CacheKey, JsonExtract.JsonExtractor<?>>(){

        public JsonExtract.JsonExtractor<?> load(CacheKey key) throws Exception {
            return JsonExtract.generateExtractor(String.format("$[\"%s\"]", key.getKey()), key.getType().getExtractor());
        }
    });

    protected MapSubscriptOperator() {
        super(OperatorType.SUBSCRIPT, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("K"), (Object)Signature.typeParameter("V")), "V", (List<String>)ImmutableList.of((Object)"map<K,V>", (Object)"K"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Signature signature = new Signature(OperatorType.SUBSCRIPT.name(), valueType.getTypeSignature(), TypeUtils.parameterizedTypeName("map", keyType.getTypeSignature(), valueType.getTypeSignature()), keyType.getTypeSignature());
        return new FunctionInfo(signature, "Map subscript", true, MapSubscriptOperator.lookupMethod(keyType, valueType), true, true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    private static MethodHandle lookupMethod(Type keyType, Type valueType) {
        String methodName = keyType.getJavaType().getSimpleName();
        methodName = valueType instanceof ArrayType || valueType instanceof MapType || valueType instanceof RowType ? methodName + "Structural" : methodName + valueType.getJavaType().getSimpleName();
        methodName = methodName + "Subscript";
        try {
            return MethodHandles.lookup().unreflect(MapSubscriptOperator.class.getMethod(methodName, Slice.class, keyType.getJavaType()));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Long SlicelongSubscript(Slice map, Slice key) {
        return (Long)MapSubscriptOperator.subscript(map, key.toStringUtf8(), ExtractorType.LONG);
    }

    public static Boolean SlicebooleanSubscript(Slice map, Slice key) {
        return (Boolean)MapSubscriptOperator.subscript(map, key.toStringUtf8(), ExtractorType.BOOLEAN);
    }

    public static Double SlicedoubleSubscript(Slice map, Slice key) {
        return (Double)MapSubscriptOperator.subscript(map, key.toStringUtf8(), ExtractorType.DOUBLE);
    }

    public static Slice SliceSliceSubscript(Slice map, Slice key) {
        return (Slice)MapSubscriptOperator.subscript(map, key.toStringUtf8(), ExtractorType.SLICE);
    }

    public static Slice SliceStructuralSubscript(Slice map, Slice key) {
        return (Slice)MapSubscriptOperator.subscript(map, key.toStringUtf8(), ExtractorType.STRUCTURAL);
    }

    public static Long doublelongSubscript(Slice map, double key) {
        return (Long)MapSubscriptOperator.subscript(map, key, ExtractorType.LONG);
    }

    public static Boolean doublebooleanSubscript(Slice map, double key) {
        return (Boolean)MapSubscriptOperator.subscript(map, key, ExtractorType.BOOLEAN);
    }

    public static Double doubledoubleSubscript(Slice map, double key) {
        return (Double)MapSubscriptOperator.subscript(map, key, ExtractorType.DOUBLE);
    }

    public static Slice doubleSliceSubscript(Slice map, double key) {
        return (Slice)MapSubscriptOperator.subscript(map, key, ExtractorType.SLICE);
    }

    public static Slice doubleStructuralSubscript(Slice map, double key) {
        return (Slice)MapSubscriptOperator.subscript(map, key, ExtractorType.STRUCTURAL);
    }

    public static Long booleanlongSubscript(Slice map, boolean key) {
        return (Long)MapSubscriptOperator.subscript(map, key, ExtractorType.LONG);
    }

    public static Boolean booleanbooleanSubscript(Slice map, boolean key) {
        return (Boolean)MapSubscriptOperator.subscript(map, key, ExtractorType.BOOLEAN);
    }

    public static Double booleandoubleSubscript(Slice map, boolean key) {
        return (Double)MapSubscriptOperator.subscript(map, key, ExtractorType.DOUBLE);
    }

    public static Slice booleanSliceSubscript(Slice map, boolean key) {
        return (Slice)MapSubscriptOperator.subscript(map, key, ExtractorType.SLICE);
    }

    public static Slice booleanStructuralSubscript(Slice map, boolean key) {
        return (Slice)MapSubscriptOperator.subscript(map, key, ExtractorType.STRUCTURAL);
    }

    public static Long longlongSubscript(Slice map, long key) {
        return (Long)MapSubscriptOperator.subscript(map, key, ExtractorType.LONG);
    }

    public static Boolean longbooleanSubscript(Slice map, long key) {
        return (Boolean)MapSubscriptOperator.subscript(map, key, ExtractorType.BOOLEAN);
    }

    public static Double longdoubleSubscript(Slice map, long key) {
        return (Double)MapSubscriptOperator.subscript(map, key, ExtractorType.DOUBLE);
    }

    public static Slice longSliceSubscript(Slice map, long key) {
        return (Slice)MapSubscriptOperator.subscript(map, key, ExtractorType.SLICE);
    }

    public static Slice longStructuralSubscript(Slice map, long key) {
        return (Slice)MapSubscriptOperator.subscript(map, key, ExtractorType.STRUCTURAL);
    }

    private static <T> T subscript(Slice map, Object key, ExtractorType type) {
        JsonExtract.JsonExtractor extractor = (JsonExtract.JsonExtractor)CACHE.getUnchecked((Object)new CacheKey(key.toString(), type));
        return JsonExtract.extract(map, extractor);
    }

    private static enum ExtractorType {
        LONG(new JsonExtract.LongJsonExtractor()),
        BOOLEAN(new JsonExtract.BooleanJsonExtractor()),
        DOUBLE(new JsonExtract.DoubleJsonExtractor()),
        SLICE(new JsonExtract.ScalarValueJsonExtractor()),
        STRUCTURAL(new JsonExtract.JsonValueJsonExtractor());

        private final JsonExtract.JsonExtractor<?> extractor;

        private ExtractorType(JsonExtract.JsonExtractor<?> extractor) {
            this.extractor = extractor;
        }

        public JsonExtract.JsonExtractor<?> getExtractor() {
            return this.extractor;
        }
    }

    private static class CacheKey {
        private final String key;
        private final ExtractorType type;

        private CacheKey(String key, ExtractorType type) {
            this.key = key;
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public ExtractorType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.key.equals(cacheKey.key)) {
                return false;
            }
            return this.type == cacheKey.type;
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

