/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MapConstructor
extends ParametricScalar {
    public static final MapConstructor MAP_CONSTRUCTOR = new MapConstructor();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Signature SIGNATURE = new Signature("map", (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.typeParameter("V")), "map<K,V>", (List<String>)ImmutableList.of((Object)"array<K>", (Object)"array<V>"), false, false);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapConstructor.class, "createMap", Slice.class, Slice.class);
    private static final String DESCRIPTION = "Constructs a map from the given key/value arrays";
    private static final ArrayType ARRAY_TYPE = MAPPER.getTypeFactory().constructArrayType(Object.class);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Type mapType = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)keyType.getTypeSignature(), (Object)valueType.getTypeSignature()), (List)ImmutableList.of());
        ImmutableList argumentTypes = ImmutableList.of((Object)TypeUtils.parameterizedTypeName("array", keyType.getTypeSignature()), (Object)TypeUtils.parameterizedTypeName("array", valueType.getTypeSignature()));
        Signature signature = new Signature("map", (List<TypeParameter>)ImmutableList.of(), mapType.getTypeSignature(), (List<TypeSignature>)argumentTypes, false, false);
        return new FunctionInfo(signature, DESCRIPTION, this.isHidden(), METHOD_HANDLE, this.isDeterministic(), false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static Slice createMap(Slice keys, Slice values) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        try {
            Object[] keysArray = (Object[])MAPPER.readValue((InputStream)keys.getInput(), (JavaType)ARRAY_TYPE);
            Object[] valuesArray = (Object[])MAPPER.readValue((InputStream)values.getInput(), (JavaType)ARRAY_TYPE);
            Failures.checkCondition(keysArray.length == valuesArray.length, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key and value arrays must be the same length", new Object[0]);
            for (int i = 0; i < keysArray.length; ++i) {
                if (keysArray[i] == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
                }
                map.put(keysArray[i], valuesArray[i]);
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return MapType.toStackRepresentation(map);
    }
}

