/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.ArrayConcatUtils;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ElementToArrayConcatFunction
extends ParametricScalar {
    public static final ElementToArrayConcatFunction ELEMENT_TO_ARRAY_CONCAT_FUNCTION = new ElementToArrayConcatFunction();
    private static final String FUNCTION_NAME = "concat";
    private static final Signature SIGNATURE = new Signature("concat", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("E")), "array<E>", (List<String>)ImmutableList.of((Object)"E", (Object)"array<E>"), false, false);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Concatenates an element to an array";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("E");
        MethodHandle methodHandle = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", type.getJavaType(), Slice.class);
        TypeSignature typeSignature = type.getTypeSignature();
        TypeSignature returnType = TypeUtils.parameterizedTypeName("array", typeSignature);
        Signature signature = new Signature(FUNCTION_NAME, returnType, typeSignature, returnType);
        return new FunctionInfo(signature, this.getDescription(), this.isHidden(), methodHandle, this.isDeterministic(), false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }
}

