/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArrayEqualOperator
extends ParametricOperator {
    public static final ArrayEqualOperator ARRAY_EQUAL = new ArrayEqualOperator();
    private static final TypeSignature RETURN_TYPE = TypeSignature.parseTypeSignature((String)"boolean");
    public static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayEqualOperator.class, "equals", Type.class, Slice.class, Slice.class);

    private ArrayEqualOperator() {
        super(OperatorType.EQUAL, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), "boolean", (List<String>)ImmutableList.of((Object)"array<T>", (Object)"array<T>"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("T");
        type = typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)type.getTypeSignature()), (List)ImmutableList.of());
        TypeSignature typeSignature = type.getTypeSignature();
        return FunctionRegistry.operatorInfo(OperatorType.EQUAL, RETURN_TYPE, (List<TypeSignature>)ImmutableList.of((Object)typeSignature, (Object)typeSignature), METHOD_HANDLE.bindTo(type), false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static boolean equals(Type type, Slice left, Slice right) {
        BlockBuilder leftBlockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        BlockBuilder rightBlockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        leftBlockBuilder.writeBytes(left, 0, left.length());
        rightBlockBuilder.writeBytes(right, 0, right.length());
        return type.equalTo(leftBlockBuilder.closeEntry().build(), 0, rightBlockBuilder.closeEntry().build(), 0);
    }
}

