/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.type.ArrayType;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Throwables;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class ArrayConcatUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new SliceSerializer()));
    private static final CollectionType COLLECTION_TYPE = OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, Object.class);

    private ArrayConcatUtils() {
    }

    public static Slice concat(Slice left, Slice right) {
        List<Object> leftArray = ArrayConcatUtils.readArray(left);
        List<Object> rightArray = ArrayConcatUtils.readArray(right);
        ArrayList<Object> result = new ArrayList<Object>(leftArray.size() + rightArray.size());
        result.addAll(leftArray);
        result.addAll(rightArray);
        return ArrayType.toStackRepresentation(result);
    }

    private static Slice concatElement(Slice in, Object value, boolean append) {
        List<Object> array = ArrayConcatUtils.readArray(in);
        ArrayList<Object> result = new ArrayList<Object>(array.size() + 1);
        if (append) {
            result.addAll(array);
            result.add(value);
        } else {
            result.add(value);
            result.addAll(array);
        }
        return ArrayType.toStackRepresentation(result);
    }

    public static Slice appendElement(Slice in, Object value) {
        return ArrayConcatUtils.concatElement(in, value, true);
    }

    public static Slice appendElement(Slice in, long value) {
        return ArrayConcatUtils.appendElement(in, (Object)value);
    }

    public static Slice appendElement(Slice in, boolean value) {
        return ArrayConcatUtils.appendElement(in, (Object)value);
    }

    public static Slice appendElement(Slice in, double value) {
        return ArrayConcatUtils.appendElement(in, (Object)value);
    }

    public static Slice appendElement(Slice in, Slice value) {
        return ArrayConcatUtils.concatElement(in, value, true);
    }

    public static Slice prependElement(Slice value, Slice in) {
        return ArrayConcatUtils.concatElement(in, value, false);
    }

    public static Slice prependElement(Object value, Slice in) {
        return ArrayConcatUtils.concatElement(in, value, false);
    }

    public static Slice prependElement(long value, Slice in) {
        return ArrayConcatUtils.prependElement((Object)value, in);
    }

    public static Slice prependElement(boolean value, Slice in) {
        return ArrayConcatUtils.prependElement((Object)value, in);
    }

    public static Slice prependElement(double value, Slice in) {
        return ArrayConcatUtils.prependElement((Object)value, in);
    }

    private static List<Object> readArray(Slice json) {
        try {
            return (List)OBJECT_MAPPER.readValue((InputStream)json.getInput(), (JavaType)COLLECTION_TYPE);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

