/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.operator.index.UnloadedIndexKeyRecordSet;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class IndexSnapshotBuilder {
    private final int expectedPositions;
    private final List<Type> outputTypes;
    private final List<Type> missingKeysTypes;
    private final List<Integer> keyOutputChannels;
    private final Optional<Integer> keyOutputHashChannel;
    private final List<Integer> missingKeysChannels;
    private final long maxMemoryInBytes;
    private final OperatorContext bogusOperatorContext;
    private PagesIndex outputPagesIndex;
    private PagesIndex missingKeysIndex;
    private LookupSource missingKeys;
    private final List<Page> pages = new ArrayList<Page>();
    private long memoryInBytes;

    public IndexSnapshotBuilder(List<Type> outputTypes, List<Integer> keyOutputChannels, Optional<Integer> keyOutputHashChannel, DriverContext driverContext, DataSize maxMemoryInBytes, int expectedPositions) {
        Preconditions.checkNotNull(outputTypes, (Object)"outputTypes is null");
        Preconditions.checkNotNull(keyOutputChannels, (Object)"keyOutputChannels is null");
        Preconditions.checkNotNull(keyOutputHashChannel, (Object)"keyOutputHashChannel is null");
        Preconditions.checkNotNull((Object)driverContext, (Object)"driverContext is null");
        Preconditions.checkNotNull((Object)maxMemoryInBytes, (Object)"maxMemoryInBytes is null");
        Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions must be greater than zero");
        this.outputTypes = ImmutableList.copyOf(outputTypes);
        this.expectedPositions = expectedPositions;
        this.keyOutputChannels = ImmutableList.copyOf(keyOutputChannels);
        this.keyOutputHashChannel = keyOutputHashChannel;
        this.maxMemoryInBytes = maxMemoryInBytes.toBytes();
        ImmutableList.Builder missingKeysTypes = ImmutableList.builder();
        ImmutableList.Builder missingKeysChannels = ImmutableList.builder();
        for (int i = 0; i < keyOutputChannels.size(); ++i) {
            Integer keyOutputChannel = keyOutputChannels.get(i);
            missingKeysTypes.add((Object)outputTypes.get(keyOutputChannel));
            missingKeysChannels.add((Object)i);
        }
        this.missingKeysTypes = missingKeysTypes.build();
        this.missingKeysChannels = missingKeysChannels.build();
        boolean cpuTimerEnabled = driverContext.getPipelineContext().getTaskContext().isCpuTimerEnabled();
        this.bogusOperatorContext = new TaskContext(driverContext.getTaskId(), driverContext.getExecutor(), driverContext.getSession(), new DataSize(9.223372036854776E18, DataSize.Unit.BYTE), cpuTimerEnabled).addPipelineContext(true, true).addDriverContext().addOperatorContext(0, "operator");
        this.outputPagesIndex = new PagesIndex(outputTypes, expectedPositions);
        this.missingKeysIndex = new PagesIndex((List<Type>)missingKeysTypes.build(), expectedPositions);
        this.missingKeys = this.missingKeysIndex.createLookupSource(this.missingKeysChannels, this.bogusOperatorContext);
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public long getMemoryInBytes() {
        return this.memoryInBytes;
    }

    public boolean isMemoryExceeded() {
        return this.memoryInBytes > this.maxMemoryInBytes;
    }

    public boolean tryAddPage(Page page) {
        this.memoryInBytes += page.getSizeInBytes();
        if (this.isMemoryExceeded()) {
            return false;
        }
        this.pages.add(page);
        return true;
    }

    public IndexSnapshot createIndexSnapshot(UnloadedIndexKeyRecordSet indexKeysRecordSet) {
        Preconditions.checkArgument((boolean)indexKeysRecordSet.getColumnTypes().equals(this.missingKeysTypes), (Object)"indexKeysRecordSet must have same schema as missingKeys");
        Preconditions.checkState((!this.isMemoryExceeded() ? 1 : 0) != 0, (Object)"Max memory exceeded");
        for (Page page : this.pages) {
            this.outputPagesIndex.addPage(page);
            this.bogusOperatorContext.setMemoryReservation(this.outputPagesIndex.getEstimatedSize().toBytes());
        }
        this.pages.clear();
        LookupSource lookupSource = this.outputPagesIndex.createLookupSource(this.keyOutputChannels, this.bogusOperatorContext, this.keyOutputHashChannel);
        PageBuilder missingKeysPageBuilder = new PageBuilder(this.missingKeysIndex.getTypes());
        UnloadedIndexKeyRecordSet.UnloadedIndexKeyRecordCursor indexKeysRecordCursor = indexKeysRecordSet.cursor();
        while (indexKeysRecordCursor.advanceNextPosition()) {
            Block[] blocks = indexKeysRecordCursor.getBlocks();
            Page page = indexKeysRecordCursor.getPage();
            int position = indexKeysRecordCursor.getPosition();
            if (lookupSource.getJoinPosition(position, page) >= 0L) continue;
            missingKeysPageBuilder.declarePosition();
            for (int i = 0; i < blocks.length; ++i) {
                Block block = blocks[i];
                Type type = indexKeysRecordCursor.getType(i);
                type.appendTo(block, position, missingKeysPageBuilder.getBlockBuilder(i));
            }
        }
        Page missingKeysPage = missingKeysPageBuilder.build();
        this.memoryInBytes += missingKeysPage.getSizeInBytes();
        if (this.isMemoryExceeded()) {
            return null;
        }
        if (!missingKeysPageBuilder.isEmpty()) {
            this.missingKeysIndex.addPage(missingKeysPage);
            this.missingKeys = this.missingKeysIndex.createLookupSource(this.missingKeysChannels, this.bogusOperatorContext);
        }
        return new IndexSnapshot(lookupSource, this.missingKeys);
    }

    public void reset() {
        this.memoryInBytes = 0L;
        this.pages.clear();
        this.outputPagesIndex = new PagesIndex(this.outputTypes, this.expectedPositions);
        this.missingKeysIndex = new PagesIndex(this.missingKeysTypes, this.expectedPositions);
    }
}

