/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexLoader;
import com.facebook.presto.operator.index.IndexLookupSource;
import com.facebook.presto.spi.type.Type;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class IndexLookupSourceSupplier
implements LookupSourceSupplier {
    private final IndexLoader indexLoader;

    public IndexLookupSourceSupplier(Set<Integer> lookupSourceInputChannels, List<Integer> keyOutputChannels, Optional<Integer> keyOutputHashChannel, List<Type> outputTypes, IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider, DataSize maxIndexMemorySize, IndexJoinLookupStats stats) {
        this.indexLoader = new IndexLoader(lookupSourceInputChannels, keyOutputChannels, keyOutputHashChannel, outputTypes, indexBuildDriverFactoryProvider, 100000, maxIndexMemorySize, stats);
    }

    @Override
    public List<Type> getTypes() {
        return this.indexLoader.getOutputTypes();
    }

    @Override
    public ListenableFuture<LookupSource> getLookupSource(OperatorContext operatorContext) {
        this.indexLoader.setContext(operatorContext.getDriverContext().getPipelineContext().getTaskContext());
        return Futures.immediateFuture((Object)new IndexLookupSource(this.indexLoader));
    }
}

