/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.index.IndexLoader;
import com.facebook.presto.operator.index.IndexedData;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IndexLookupSource
implements LookupSource {
    private final IndexLoader indexLoader;
    private IndexedData indexedData;

    public IndexLookupSource(IndexLoader indexLoader) {
        this.indexLoader = (IndexLoader)Preconditions.checkNotNull((Object)indexLoader, (Object)"indexLoader is null");
        this.indexedData = indexLoader.getIndexSnapshot();
    }

    @Override
    public int getChannelCount() {
        return this.indexLoader.getChannelCount();
    }

    @Override
    public long getJoinPosition(int position, Page page, int rawHash) {
        return this.getJoinPosition(position, page);
    }

    @Override
    public long getJoinPosition(int position, Page page) {
        Block[] blocks = page.getBlocks();
        long joinPosition = this.indexedData.getJoinPosition(position, page);
        if (joinPosition == -2L) {
            this.indexedData.close();
            this.indexedData = this.indexLoader.getIndexedDataForKeys(position, blocks);
            joinPosition = this.indexedData.getJoinPosition(position, page);
            Preconditions.checkState((joinPosition != -2L ? 1 : 0) != 0);
        }
        return joinPosition;
    }

    @Override
    public long getNextJoinPosition(long currentPosition) {
        long nextPosition = this.indexedData.getNextJoinPosition(currentPosition);
        Preconditions.checkState((nextPosition != -2L ? 1 : 0) != 0);
        return nextPosition;
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.indexedData.appendTo(position, pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
        this.indexedData.close();
    }
}

